package zio.aws.wafv2.model
import zio.aws.wafv2.model.primitives.{
  Action,
  SampleWeight,
  Timestamp,
  ResponseStatusCode,
  EntityName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class SampledHTTPRequest(
    request: zio.aws.wafv2.model.HTTPRequest,
    weight: SampleWeight,
    timestamp: Optional[Timestamp] = Optional.Absent,
    action: Optional[Action] = Optional.Absent,
    ruleNameWithinRuleGroup: Optional[EntityName] = Optional.Absent,
    requestHeadersInserted: Optional[Iterable[zio.aws.wafv2.model.HTTPHeader]] =
      Optional.Absent,
    responseCodeSent: Optional[ResponseStatusCode] = Optional.Absent,
    labels: Optional[Iterable[zio.aws.wafv2.model.Label]] = Optional.Absent,
    captchaResponse: Optional[zio.aws.wafv2.model.CaptchaResponse] =
      Optional.Absent,
    challengeResponse: Optional[zio.aws.wafv2.model.ChallengeResponse] =
      Optional.Absent,
    overriddenAction: Optional[Action] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.SampledHTTPRequest = {
    import SampledHTTPRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.SampledHTTPRequest
      .builder()
      .request(request.buildAwsValue())
      .weight(SampleWeight.unwrap(weight): java.lang.Long)
      .optionallyWith(timestamp.map(value => Timestamp.unwrap(value): Instant))(
        _.timestamp
      )
      .optionallyWith(
        action.map(value => Action.unwrap(value): java.lang.String)
      )(_.action)
      .optionallyWith(
        ruleNameWithinRuleGroup.map(value =>
          EntityName.unwrap(value): java.lang.String
        )
      )(_.ruleNameWithinRuleGroup)
      .optionallyWith(
        requestHeadersInserted.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.requestHeadersInserted)
      .optionallyWith(
        responseCodeSent.map(value => ResponseStatusCode.unwrap(value): Integer)
      )(_.responseCodeSent)
      .optionallyWith(
        labels.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.labels)
      .optionallyWith(captchaResponse.map(value => value.buildAwsValue()))(
        _.captchaResponse
      )
      .optionallyWith(challengeResponse.map(value => value.buildAwsValue()))(
        _.challengeResponse
      )
      .optionallyWith(
        overriddenAction.map(value => Action.unwrap(value): java.lang.String)
      )(_.overriddenAction)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.SampledHTTPRequest.ReadOnly =
    zio.aws.wafv2.model.SampledHTTPRequest.wrap(buildAwsValue())
}
object SampledHTTPRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.SampledHTTPRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.SampledHTTPRequest =
      zio.aws.wafv2.model.SampledHTTPRequest(
        request.asEditable,
        weight,
        timestamp.map(value => value),
        action.map(value => value),
        ruleNameWithinRuleGroup.map(value => value),
        requestHeadersInserted.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        responseCodeSent.map(value => value),
        labels.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        captchaResponse.map(value => value.asEditable),
        challengeResponse.map(value => value.asEditable),
        overriddenAction.map(value => value)
      )
    def request: zio.aws.wafv2.model.HTTPRequest.ReadOnly
    def weight: SampleWeight
    def timestamp: Optional[Timestamp]
    def action: Optional[Action]
    def ruleNameWithinRuleGroup: Optional[EntityName]
    def requestHeadersInserted
        : Optional[List[zio.aws.wafv2.model.HTTPHeader.ReadOnly]]
    def responseCodeSent: Optional[ResponseStatusCode]
    def labels: Optional[List[zio.aws.wafv2.model.Label.ReadOnly]]
    def captchaResponse: Optional[zio.aws.wafv2.model.CaptchaResponse.ReadOnly]
    def challengeResponse
        : Optional[zio.aws.wafv2.model.ChallengeResponse.ReadOnly]
    def overriddenAction: Optional[Action]
    def getRequest
        : ZIO[Any, Nothing, zio.aws.wafv2.model.HTTPRequest.ReadOnly] =
      ZIO.succeed(request)
    def getWeight: ZIO[Any, Nothing, SampleWeight] = ZIO.succeed(weight)
    def getTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
    def getAction: ZIO[Any, AwsError, Action] =
      AwsError.unwrapOptionField("action", action)
    def getRuleNameWithinRuleGroup: ZIO[Any, AwsError, EntityName] = AwsError
      .unwrapOptionField("ruleNameWithinRuleGroup", ruleNameWithinRuleGroup)
    def getRequestHeadersInserted
        : ZIO[Any, AwsError, List[zio.aws.wafv2.model.HTTPHeader.ReadOnly]] =
      AwsError.unwrapOptionField(
        "requestHeadersInserted",
        requestHeadersInserted
      )
    def getResponseCodeSent: ZIO[Any, AwsError, ResponseStatusCode] =
      AwsError.unwrapOptionField("responseCodeSent", responseCodeSent)
    def getLabels
        : ZIO[Any, AwsError, List[zio.aws.wafv2.model.Label.ReadOnly]] =
      AwsError.unwrapOptionField("labels", labels)
    def getCaptchaResponse
        : ZIO[Any, AwsError, zio.aws.wafv2.model.CaptchaResponse.ReadOnly] =
      AwsError.unwrapOptionField("captchaResponse", captchaResponse)
    def getChallengeResponse
        : ZIO[Any, AwsError, zio.aws.wafv2.model.ChallengeResponse.ReadOnly] =
      AwsError.unwrapOptionField("challengeResponse", challengeResponse)
    def getOverriddenAction: ZIO[Any, AwsError, Action] =
      AwsError.unwrapOptionField("overriddenAction", overriddenAction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.SampledHTTPRequest
  ) extends zio.aws.wafv2.model.SampledHTTPRequest.ReadOnly {
    override val request: zio.aws.wafv2.model.HTTPRequest.ReadOnly =
      zio.aws.wafv2.model.HTTPRequest.wrap(impl.request())
    override val weight: SampleWeight =
      zio.aws.wafv2.model.primitives.SampleWeight(impl.weight())
    override val timestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.timestamp())
      .map(value => zio.aws.wafv2.model.primitives.Timestamp(value))
    override val action: Optional[Action] = zio.aws.core.internal
      .optionalFromNullable(impl.action())
      .map(value => zio.aws.wafv2.model.primitives.Action(value))
    override val ruleNameWithinRuleGroup: Optional[EntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ruleNameWithinRuleGroup())
        .map(value => zio.aws.wafv2.model.primitives.EntityName(value))
    override val requestHeadersInserted
        : Optional[List[zio.aws.wafv2.model.HTTPHeader.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestHeadersInserted())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.HTTPHeader.wrap(item)
          }.toList
        )
    override val responseCodeSent: Optional[ResponseStatusCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.responseCodeSent())
        .map(value => zio.aws.wafv2.model.primitives.ResponseStatusCode(value))
    override val labels: Optional[List[zio.aws.wafv2.model.Label.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.labels())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.Label.wrap(item)
          }.toList
        )
    override val captchaResponse
        : Optional[zio.aws.wafv2.model.CaptchaResponse.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.captchaResponse())
        .map(value => zio.aws.wafv2.model.CaptchaResponse.wrap(value))
    override val challengeResponse
        : Optional[zio.aws.wafv2.model.ChallengeResponse.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.challengeResponse())
        .map(value => zio.aws.wafv2.model.ChallengeResponse.wrap(value))
    override val overriddenAction: Optional[Action] = zio.aws.core.internal
      .optionalFromNullable(impl.overriddenAction())
      .map(value => zio.aws.wafv2.model.primitives.Action(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.SampledHTTPRequest
  ): zio.aws.wafv2.model.SampledHTTPRequest.ReadOnly = new Wrapper(impl)
}
