package zio.aws.wafv2.model
import scala.jdk.CollectionConverters.*
sealed trait Scope {
  def unwrap: software.amazon.awssdk.services.wafv2.model.Scope
}
object Scope {
  def wrap(
      value: software.amazon.awssdk.services.wafv2.model.Scope
  ): zio.aws.wafv2.model.Scope = value match {
    case software.amazon.awssdk.services.wafv2.model.Scope.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.wafv2.model.Scope.CLOUDFRONT =>
      val r = CLOUDFRONT
      r
    case software.amazon.awssdk.services.wafv2.model.Scope.REGIONAL =>
      val r = REGIONAL
      r
  }
  case object unknownToSdkVersion extends zio.aws.wafv2.model.Scope {
    override def unwrap: software.amazon.awssdk.services.wafv2.model.Scope =
      software.amazon.awssdk.services.wafv2.model.Scope.UNKNOWN_TO_SDK_VERSION
  }
  case object CLOUDFRONT extends zio.aws.wafv2.model.Scope {
    override def unwrap: software.amazon.awssdk.services.wafv2.model.Scope =
      software.amazon.awssdk.services.wafv2.model.Scope.CLOUDFRONT
  }
  case object REGIONAL extends zio.aws.wafv2.model.Scope {
    override def unwrap: software.amazon.awssdk.services.wafv2.model.Scope =
      software.amazon.awssdk.services.wafv2.model.Scope.REGIONAL
  }
}
