package zio.aws.wafv2.model
import scala.jdk.CollectionConverters.*
sealed trait SensitivityLevel {
  def unwrap: software.amazon.awssdk.services.wafv2.model.SensitivityLevel
}
object SensitivityLevel {
  def wrap(
      value: software.amazon.awssdk.services.wafv2.model.SensitivityLevel
  ): zio.aws.wafv2.model.SensitivityLevel = value match {
    case software.amazon.awssdk.services.wafv2.model.SensitivityLevel.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.wafv2.model.SensitivityLevel.LOW =>
      val r = LOW
      r
    case software.amazon.awssdk.services.wafv2.model.SensitivityLevel.HIGH =>
      val r = HIGH
      r
  }
  case object unknownToSdkVersion extends zio.aws.wafv2.model.SensitivityLevel {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.SensitivityLevel =
      software.amazon.awssdk.services.wafv2.model.SensitivityLevel.UNKNOWN_TO_SDK_VERSION
  }
  case object LOW extends zio.aws.wafv2.model.SensitivityLevel {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.SensitivityLevel =
      software.amazon.awssdk.services.wafv2.model.SensitivityLevel.LOW
  }
  case object HIGH extends zio.aws.wafv2.model.SensitivityLevel {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.SensitivityLevel =
      software.amazon.awssdk.services.wafv2.model.SensitivityLevel.HIGH
  }
}
