package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.FieldToMatchData
import scala.jdk.CollectionConverters.*
final case class SingleHeader(name: FieldToMatchData) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.SingleHeader = {
    import SingleHeader.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.SingleHeader
      .builder()
      .name(FieldToMatchData.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.SingleHeader.ReadOnly =
    zio.aws.wafv2.model.SingleHeader.wrap(buildAwsValue())
}
object SingleHeader {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.SingleHeader
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.SingleHeader =
      zio.aws.wafv2.model.SingleHeader(name)
    def name: FieldToMatchData
    def getName: ZIO[Any, Nothing, FieldToMatchData] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.SingleHeader
  ) extends zio.aws.wafv2.model.SingleHeader.ReadOnly {
    override val name: FieldToMatchData =
      zio.aws.wafv2.model.primitives.FieldToMatchData(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.SingleHeader
  ): zio.aws.wafv2.model.SingleHeader.ReadOnly = new Wrapper(impl)
}
