package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.FieldToMatchData
import scala.jdk.CollectionConverters.*
final case class SingleQueryArgument(name: FieldToMatchData) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.SingleQueryArgument = {
    import SingleQueryArgument.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.SingleQueryArgument
      .builder()
      .name(FieldToMatchData.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.SingleQueryArgument.ReadOnly =
    zio.aws.wafv2.model.SingleQueryArgument.wrap(buildAwsValue())
}
object SingleQueryArgument {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.SingleQueryArgument
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.SingleQueryArgument =
      zio.aws.wafv2.model.SingleQueryArgument(name)
    def name: FieldToMatchData
    def getName: ZIO[Any, Nothing, FieldToMatchData] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.SingleQueryArgument
  ) extends zio.aws.wafv2.model.SingleQueryArgument.ReadOnly {
    override val name: FieldToMatchData =
      zio.aws.wafv2.model.primitives.FieldToMatchData(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.SingleQueryArgument
  ): zio.aws.wafv2.model.SingleQueryArgument.ReadOnly = new Wrapper(impl)
}
