package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.Size
import scala.jdk.CollectionConverters.*
final case class SizeConstraintStatement(
    fieldToMatch: zio.aws.wafv2.model.FieldToMatch,
    comparisonOperator: zio.aws.wafv2.model.ComparisonOperator,
    size: Size,
    textTransformations: Iterable[zio.aws.wafv2.model.TextTransformation]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.SizeConstraintStatement = {
    import SizeConstraintStatement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.SizeConstraintStatement
      .builder()
      .fieldToMatch(fieldToMatch.buildAwsValue())
      .comparisonOperator(comparisonOperator.unwrap)
      .size(Size.unwrap(size): java.lang.Long)
      .textTransformations(textTransformations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.SizeConstraintStatement.ReadOnly =
    zio.aws.wafv2.model.SizeConstraintStatement.wrap(buildAwsValue())
}
object SizeConstraintStatement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.SizeConstraintStatement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.SizeConstraintStatement =
      zio.aws.wafv2.model.SizeConstraintStatement(
        fieldToMatch.asEditable,
        comparisonOperator,
        size,
        textTransformations.map { item =>
          item.asEditable
        }
      )
    def fieldToMatch: zio.aws.wafv2.model.FieldToMatch.ReadOnly
    def comparisonOperator: zio.aws.wafv2.model.ComparisonOperator
    def size: Size
    def textTransformations
        : List[zio.aws.wafv2.model.TextTransformation.ReadOnly]
    def getFieldToMatch
        : ZIO[Any, Nothing, zio.aws.wafv2.model.FieldToMatch.ReadOnly] =
      ZIO.succeed(fieldToMatch)
    def getComparisonOperator
        : ZIO[Any, Nothing, zio.aws.wafv2.model.ComparisonOperator] =
      ZIO.succeed(comparisonOperator)
    def getSize: ZIO[Any, Nothing, Size] = ZIO.succeed(size)
    def getTextTransformations: ZIO[Any, Nothing, List[
      zio.aws.wafv2.model.TextTransformation.ReadOnly
    ]] = ZIO.succeed(textTransformations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.SizeConstraintStatement
  ) extends zio.aws.wafv2.model.SizeConstraintStatement.ReadOnly {
    override val fieldToMatch: zio.aws.wafv2.model.FieldToMatch.ReadOnly =
      zio.aws.wafv2.model.FieldToMatch.wrap(impl.fieldToMatch())
    override val comparisonOperator: zio.aws.wafv2.model.ComparisonOperator =
      zio.aws.wafv2.model.ComparisonOperator.wrap(impl.comparisonOperator())
    override val size: Size = zio.aws.wafv2.model.primitives.Size(impl.size())
    override val textTransformations
        : List[zio.aws.wafv2.model.TextTransformation.ReadOnly] = impl
      .textTransformations()
      .asScala
      .map { item =>
        zio.aws.wafv2.model.TextTransformation.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.SizeConstraintStatement
  ): zio.aws.wafv2.model.SizeConstraintStatement.ReadOnly = new Wrapper(impl)
}
