package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SqliMatchStatement(
    fieldToMatch: zio.aws.wafv2.model.FieldToMatch,
    textTransformations: Iterable[zio.aws.wafv2.model.TextTransformation],
    sensitivityLevel: Optional[zio.aws.wafv2.model.SensitivityLevel] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.SqliMatchStatement = {
    import SqliMatchStatement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.SqliMatchStatement
      .builder()
      .fieldToMatch(fieldToMatch.buildAwsValue())
      .textTransformations(textTransformations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(sensitivityLevel.map(value => value.unwrap))(
        _.sensitivityLevel
      )
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.SqliMatchStatement.ReadOnly =
    zio.aws.wafv2.model.SqliMatchStatement.wrap(buildAwsValue())
}
object SqliMatchStatement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.SqliMatchStatement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.SqliMatchStatement =
      zio.aws.wafv2.model.SqliMatchStatement(
        fieldToMatch.asEditable,
        textTransformations.map { item =>
          item.asEditable
        },
        sensitivityLevel.map(value => value)
      )
    def fieldToMatch: zio.aws.wafv2.model.FieldToMatch.ReadOnly
    def textTransformations
        : List[zio.aws.wafv2.model.TextTransformation.ReadOnly]
    def sensitivityLevel: Optional[zio.aws.wafv2.model.SensitivityLevel]
    def getFieldToMatch
        : ZIO[Any, Nothing, zio.aws.wafv2.model.FieldToMatch.ReadOnly] =
      ZIO.succeed(fieldToMatch)
    def getTextTransformations: ZIO[Any, Nothing, List[
      zio.aws.wafv2.model.TextTransformation.ReadOnly
    ]] = ZIO.succeed(textTransformations)
    def getSensitivityLevel
        : ZIO[Any, AwsError, zio.aws.wafv2.model.SensitivityLevel] =
      AwsError.unwrapOptionField("sensitivityLevel", sensitivityLevel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.SqliMatchStatement
  ) extends zio.aws.wafv2.model.SqliMatchStatement.ReadOnly {
    override val fieldToMatch: zio.aws.wafv2.model.FieldToMatch.ReadOnly =
      zio.aws.wafv2.model.FieldToMatch.wrap(impl.fieldToMatch())
    override val textTransformations
        : List[zio.aws.wafv2.model.TextTransformation.ReadOnly] = impl
      .textTransformations()
      .asScala
      .map { item =>
        zio.aws.wafv2.model.TextTransformation.wrap(item)
      }
      .toList
    override val sensitivityLevel
        : Optional[zio.aws.wafv2.model.SensitivityLevel] = zio.aws.core.internal
      .optionalFromNullable(impl.sensitivityLevel())
      .map(value => zio.aws.wafv2.model.SensitivityLevel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.SqliMatchStatement
  ): zio.aws.wafv2.model.SqliMatchStatement.ReadOnly = new Wrapper(impl)
}
