package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.ResourceArn
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    resourceARN: ResourceArn,
    tags: Iterable[zio.aws.wafv2.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.TagResourceRequest
      .builder()
      .resourceARN(ResourceArn.unwrap(resourceARN): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.TagResourceRequest.ReadOnly =
    zio.aws.wafv2.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.TagResourceRequest =
      zio.aws.wafv2.model.TagResourceRequest(
        resourceARN,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceARN: ResourceArn
    def tags: List[zio.aws.wafv2.model.Tag.ReadOnly]
    def getResourceARN: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceARN)
    def getTags: ZIO[Any, Nothing, List[zio.aws.wafv2.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.TagResourceRequest
  ) extends zio.aws.wafv2.model.TagResourceRequest.ReadOnly {
    override val resourceARN: ResourceArn =
      zio.aws.wafv2.model.primitives.ResourceArn(impl.resourceARN())
    override val tags: List[zio.aws.wafv2.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.wafv2.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.TagResourceRequest
  ): zio.aws.wafv2.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
