package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.wafv2.model.primitives.Timestamp
import scala.jdk.CollectionConverters.*
final case class TimeWindow(startTime: Timestamp, endTime: Timestamp) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.TimeWindow = {
    import TimeWindow.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.TimeWindow
      .builder()
      .startTime(Timestamp.unwrap(startTime): Instant)
      .endTime(Timestamp.unwrap(endTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.TimeWindow.ReadOnly =
    zio.aws.wafv2.model.TimeWindow.wrap(buildAwsValue())
}
object TimeWindow {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.wafv2.model.TimeWindow] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.TimeWindow =
      zio.aws.wafv2.model.TimeWindow(startTime, endTime)
    def startTime: Timestamp
    def endTime: Timestamp
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
    def getEndTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.TimeWindow
  ) extends zio.aws.wafv2.model.TimeWindow.ReadOnly {
    override val startTime: Timestamp =
      zio.aws.wafv2.model.primitives.Timestamp(impl.startTime())
    override val endTime: Timestamp =
      zio.aws.wafv2.model.primitives.Timestamp(impl.endTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.TimeWindow
  ): zio.aws.wafv2.model.TimeWindow.ReadOnly = new Wrapper(impl)
}
