package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wafv2.model.primitives.{
  LockToken,
  EntityId,
  EntityDescription,
  EntityName,
  IPAddress
}
import scala.jdk.CollectionConverters.*
final case class UpdateIpSetRequest(
    name: EntityName,
    scope: zio.aws.wafv2.model.Scope,
    id: EntityId,
    description: Optional[EntityDescription] = Optional.Absent,
    addresses: Iterable[IPAddress],
    lockToken: LockToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.UpdateIpSetRequest = {
    import UpdateIpSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.UpdateIpSetRequest
      .builder()
      .name(EntityName.unwrap(name): java.lang.String)
      .scope(scope.unwrap)
      .id(EntityId.unwrap(id): java.lang.String)
      .optionallyWith(
        description.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .addresses(addresses.map { item =>
        IPAddress.unwrap(item): java.lang.String
      }.asJavaCollection)
      .lockToken(LockToken.unwrap(lockToken): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.UpdateIpSetRequest.ReadOnly =
    zio.aws.wafv2.model.UpdateIpSetRequest.wrap(buildAwsValue())
}
object UpdateIpSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.UpdateIpSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.UpdateIpSetRequest =
      zio.aws.wafv2.model.UpdateIpSetRequest(
        name,
        scope,
        id,
        description.map(value => value),
        addresses,
        lockToken
      )
    def name: EntityName
    def scope: zio.aws.wafv2.model.Scope
    def id: EntityId
    def description: Optional[EntityDescription]
    def addresses: List[IPAddress]
    def lockToken: LockToken
    def getName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(name)
    def getScope: ZIO[Any, Nothing, zio.aws.wafv2.model.Scope] =
      ZIO.succeed(scope)
    def getId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(id)
    def getDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField("description", description)
    def getAddresses: ZIO[Any, Nothing, List[IPAddress]] =
      ZIO.succeed(addresses)
    def getLockToken: ZIO[Any, Nothing, LockToken] = ZIO.succeed(lockToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.UpdateIpSetRequest
  ) extends zio.aws.wafv2.model.UpdateIpSetRequest.ReadOnly {
    override val name: EntityName =
      zio.aws.wafv2.model.primitives.EntityName(impl.name())
    override val scope: zio.aws.wafv2.model.Scope =
      zio.aws.wafv2.model.Scope.wrap(impl.scope())
    override val id: EntityId =
      zio.aws.wafv2.model.primitives.EntityId(impl.id())
    override val description: Optional[EntityDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.wafv2.model.primitives.EntityDescription(value))
    override val addresses: List[IPAddress] = impl
      .addresses()
      .asScala
      .map { item =>
        zio.aws.wafv2.model.primitives.IPAddress(item)
      }
      .toList
    override val lockToken: LockToken =
      zio.aws.wafv2.model.primitives.LockToken(impl.lockToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.UpdateIpSetRequest
  ): zio.aws.wafv2.model.UpdateIpSetRequest.ReadOnly = new Wrapper(impl)
}
