package zio.aws.wafv2.model
import zio.aws.wafv2.model.primitives.{LockToken, Timestamp, VersionKeyString}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class UpdateManagedRuleSetVersionExpiryDateResponse(
    expiringVersion: Optional[VersionKeyString] = Optional.Absent,
    expiryTimestamp: Optional[Timestamp] = Optional.Absent,
    nextLockToken: Optional[LockToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.UpdateManagedRuleSetVersionExpiryDateResponse = {
    import UpdateManagedRuleSetVersionExpiryDateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.UpdateManagedRuleSetVersionExpiryDateResponse
      .builder()
      .optionallyWith(
        expiringVersion.map(value =>
          VersionKeyString.unwrap(value): java.lang.String
        )
      )(_.expiringVersion)
      .optionallyWith(
        expiryTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.expiryTimestamp)
      .optionallyWith(
        nextLockToken.map(value => LockToken.unwrap(value): java.lang.String)
      )(_.nextLockToken)
      .build()
  }
  def asReadOnly
      : zio.aws.wafv2.model.UpdateManagedRuleSetVersionExpiryDateResponse.ReadOnly =
    zio.aws.wafv2.model.UpdateManagedRuleSetVersionExpiryDateResponse
      .wrap(buildAwsValue())
}
object UpdateManagedRuleSetVersionExpiryDateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.UpdateManagedRuleSetVersionExpiryDateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.wafv2.model.UpdateManagedRuleSetVersionExpiryDateResponse =
      zio.aws.wafv2.model.UpdateManagedRuleSetVersionExpiryDateResponse(
        expiringVersion.map(value => value),
        expiryTimestamp.map(value => value),
        nextLockToken.map(value => value)
      )
    def expiringVersion: Optional[VersionKeyString]
    def expiryTimestamp: Optional[Timestamp]
    def nextLockToken: Optional[LockToken]
    def getExpiringVersion: ZIO[Any, AwsError, VersionKeyString] =
      AwsError.unwrapOptionField("expiringVersion", expiringVersion)
    def getExpiryTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("expiryTimestamp", expiryTimestamp)
    def getNextLockToken: ZIO[Any, AwsError, LockToken] =
      AwsError.unwrapOptionField("nextLockToken", nextLockToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.UpdateManagedRuleSetVersionExpiryDateResponse
  ) extends zio.aws.wafv2.model.UpdateManagedRuleSetVersionExpiryDateResponse.ReadOnly {
    override val expiringVersion: Optional[VersionKeyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expiringVersion())
        .map(value => zio.aws.wafv2.model.primitives.VersionKeyString(value))
    override val expiryTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.expiryTimestamp())
      .map(value => zio.aws.wafv2.model.primitives.Timestamp(value))
    override val nextLockToken: Optional[LockToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextLockToken())
      .map(value => zio.aws.wafv2.model.primitives.LockToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.UpdateManagedRuleSetVersionExpiryDateResponse
  ): zio.aws.wafv2.model.UpdateManagedRuleSetVersionExpiryDateResponse.ReadOnly =
    new Wrapper(impl)
}
