package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wafv2.model.primitives.{
  LockToken,
  EntityDescription,
  EntityId,
  EntityName
}
import scala.jdk.CollectionConverters.*
final case class UpdateRegexPatternSetRequest(
    name: EntityName,
    scope: zio.aws.wafv2.model.Scope,
    id: EntityId,
    description: Optional[EntityDescription] = Optional.Absent,
    regularExpressionList: Iterable[zio.aws.wafv2.model.Regex],
    lockToken: LockToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.UpdateRegexPatternSetRequest = {
    import UpdateRegexPatternSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.UpdateRegexPatternSetRequest
      .builder()
      .name(EntityName.unwrap(name): java.lang.String)
      .scope(scope.unwrap)
      .id(EntityId.unwrap(id): java.lang.String)
      .optionallyWith(
        description.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .regularExpressionList(regularExpressionList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .lockToken(LockToken.unwrap(lockToken): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.UpdateRegexPatternSetRequest.ReadOnly =
    zio.aws.wafv2.model.UpdateRegexPatternSetRequest.wrap(buildAwsValue())
}
object UpdateRegexPatternSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.UpdateRegexPatternSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.UpdateRegexPatternSetRequest =
      zio.aws.wafv2.model.UpdateRegexPatternSetRequest(
        name,
        scope,
        id,
        description.map(value => value),
        regularExpressionList.map { item =>
          item.asEditable
        },
        lockToken
      )
    def name: EntityName
    def scope: zio.aws.wafv2.model.Scope
    def id: EntityId
    def description: Optional[EntityDescription]
    def regularExpressionList: List[zio.aws.wafv2.model.Regex.ReadOnly]
    def lockToken: LockToken
    def getName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(name)
    def getScope: ZIO[Any, Nothing, zio.aws.wafv2.model.Scope] =
      ZIO.succeed(scope)
    def getId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(id)
    def getDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField("description", description)
    def getRegularExpressionList
        : ZIO[Any, Nothing, List[zio.aws.wafv2.model.Regex.ReadOnly]] =
      ZIO.succeed(regularExpressionList)
    def getLockToken: ZIO[Any, Nothing, LockToken] = ZIO.succeed(lockToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.UpdateRegexPatternSetRequest
  ) extends zio.aws.wafv2.model.UpdateRegexPatternSetRequest.ReadOnly {
    override val name: EntityName =
      zio.aws.wafv2.model.primitives.EntityName(impl.name())
    override val scope: zio.aws.wafv2.model.Scope =
      zio.aws.wafv2.model.Scope.wrap(impl.scope())
    override val id: EntityId =
      zio.aws.wafv2.model.primitives.EntityId(impl.id())
    override val description: Optional[EntityDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.wafv2.model.primitives.EntityDescription(value))
    override val regularExpressionList
        : List[zio.aws.wafv2.model.Regex.ReadOnly] = impl
      .regularExpressionList()
      .asScala
      .map { item =>
        zio.aws.wafv2.model.Regex.wrap(item)
      }
      .toList
    override val lockToken: LockToken =
      zio.aws.wafv2.model.primitives.LockToken(impl.lockToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.UpdateRegexPatternSetRequest
  ): zio.aws.wafv2.model.UpdateRegexPatternSetRequest.ReadOnly = new Wrapper(
    impl
  )
}
