package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wafv2.model.primitives.{
  TokenDomain,
  ConsumedCapacity,
  LabelName,
  EntityId,
  ResourceArn,
  EntityDescription,
  EntityName
}
import scala.jdk.CollectionConverters.*
final case class WebACL(
    name: EntityName,
    id: EntityId,
    arn: ResourceArn,
    defaultAction: zio.aws.wafv2.model.DefaultAction,
    description: Optional[EntityDescription] = Optional.Absent,
    rules: Optional[Iterable[zio.aws.wafv2.model.Rule]] = Optional.Absent,
    visibilityConfig: zio.aws.wafv2.model.VisibilityConfig,
    capacity: Optional[ConsumedCapacity] = Optional.Absent,
    preProcessFirewallManagerRuleGroups: Optional[
      Iterable[zio.aws.wafv2.model.FirewallManagerRuleGroup]
    ] = Optional.Absent,
    postProcessFirewallManagerRuleGroups: Optional[
      Iterable[zio.aws.wafv2.model.FirewallManagerRuleGroup]
    ] = Optional.Absent,
    managedByFirewallManager: Optional[Boolean] = Optional.Absent,
    labelNamespace: Optional[LabelName] = Optional.Absent,
    customResponseBodies: Optional[
      Map[EntityName, zio.aws.wafv2.model.CustomResponseBody]
    ] = Optional.Absent,
    captchaConfig: Optional[zio.aws.wafv2.model.CaptchaConfig] =
      Optional.Absent,
    challengeConfig: Optional[zio.aws.wafv2.model.ChallengeConfig] =
      Optional.Absent,
    tokenDomains: Optional[Iterable[TokenDomain]] = Optional.Absent,
    associationConfig: Optional[zio.aws.wafv2.model.AssociationConfig] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.wafv2.model.WebACL = {
    import WebACL.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.WebACL
      .builder()
      .name(EntityName.unwrap(name): java.lang.String)
      .id(EntityId.unwrap(id): java.lang.String)
      .arn(ResourceArn.unwrap(arn): java.lang.String)
      .defaultAction(defaultAction.buildAwsValue())
      .optionallyWith(
        description.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        rules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rules)
      .visibilityConfig(visibilityConfig.buildAwsValue())
      .optionallyWith(
        capacity.map(value => ConsumedCapacity.unwrap(value): java.lang.Long)
      )(_.capacity)
      .optionallyWith(
        preProcessFirewallManagerRuleGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.preProcessFirewallManagerRuleGroups)
      .optionallyWith(
        postProcessFirewallManagerRuleGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.postProcessFirewallManagerRuleGroups)
      .optionallyWith(
        managedByFirewallManager.map(value => value: java.lang.Boolean)
      )(_.managedByFirewallManager)
      .optionallyWith(
        labelNamespace.map(value => LabelName.unwrap(value): java.lang.String)
      )(_.labelNamespace)
      .optionallyWith(
        customResponseBodies.map(value =>
          value
            .map({ case (key, value) =>
              (EntityName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.customResponseBodies)
      .optionallyWith(captchaConfig.map(value => value.buildAwsValue()))(
        _.captchaConfig
      )
      .optionallyWith(challengeConfig.map(value => value.buildAwsValue()))(
        _.challengeConfig
      )
      .optionallyWith(
        tokenDomains.map(value =>
          value.map { item =>
            TokenDomain.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.tokenDomains)
      .optionallyWith(associationConfig.map(value => value.buildAwsValue()))(
        _.associationConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.WebACL.ReadOnly =
    zio.aws.wafv2.model.WebACL.wrap(buildAwsValue())
}
object WebACL {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.wafv2.model.WebACL] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.WebACL = zio.aws.wafv2.model.WebACL(
      name,
      id,
      arn,
      defaultAction.asEditable,
      description.map(value => value),
      rules.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      visibilityConfig.asEditable,
      capacity.map(value => value),
      preProcessFirewallManagerRuleGroups.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      postProcessFirewallManagerRuleGroups.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      managedByFirewallManager.map(value => value),
      labelNamespace.map(value => value),
      customResponseBodies.map(value =>
        value.map({ case (key, value) =>
          key -> value.asEditable
        })
      ),
      captchaConfig.map(value => value.asEditable),
      challengeConfig.map(value => value.asEditable),
      tokenDomains.map(value => value),
      associationConfig.map(value => value.asEditable)
    )
    def name: EntityName
    def id: EntityId
    def arn: ResourceArn
    def defaultAction: zio.aws.wafv2.model.DefaultAction.ReadOnly
    def description: Optional[EntityDescription]
    def rules: Optional[List[zio.aws.wafv2.model.Rule.ReadOnly]]
    def visibilityConfig: zio.aws.wafv2.model.VisibilityConfig.ReadOnly
    def capacity: Optional[ConsumedCapacity]
    def preProcessFirewallManagerRuleGroups
        : Optional[List[zio.aws.wafv2.model.FirewallManagerRuleGroup.ReadOnly]]
    def postProcessFirewallManagerRuleGroups
        : Optional[List[zio.aws.wafv2.model.FirewallManagerRuleGroup.ReadOnly]]
    def managedByFirewallManager: Optional[Boolean]
    def labelNamespace: Optional[LabelName]
    def customResponseBodies: Optional[
      Map[EntityName, zio.aws.wafv2.model.CustomResponseBody.ReadOnly]
    ]
    def captchaConfig: Optional[zio.aws.wafv2.model.CaptchaConfig.ReadOnly]
    def challengeConfig: Optional[zio.aws.wafv2.model.ChallengeConfig.ReadOnly]
    def tokenDomains: Optional[List[TokenDomain]]
    def associationConfig
        : Optional[zio.aws.wafv2.model.AssociationConfig.ReadOnly]
    def getName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(name)
    def getId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(id)
    def getArn: ZIO[Any, Nothing, ResourceArn] = ZIO.succeed(arn)
    def getDefaultAction
        : ZIO[Any, Nothing, zio.aws.wafv2.model.DefaultAction.ReadOnly] =
      ZIO.succeed(defaultAction)
    def getDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField("description", description)
    def getRules: ZIO[Any, AwsError, List[zio.aws.wafv2.model.Rule.ReadOnly]] =
      AwsError.unwrapOptionField("rules", rules)
    def getVisibilityConfig
        : ZIO[Any, Nothing, zio.aws.wafv2.model.VisibilityConfig.ReadOnly] =
      ZIO.succeed(visibilityConfig)
    def getCapacity: ZIO[Any, AwsError, ConsumedCapacity] =
      AwsError.unwrapOptionField("capacity", capacity)
    def getPreProcessFirewallManagerRuleGroups: ZIO[Any, AwsError, List[
      zio.aws.wafv2.model.FirewallManagerRuleGroup.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "preProcessFirewallManagerRuleGroups",
      preProcessFirewallManagerRuleGroups
    )
    def getPostProcessFirewallManagerRuleGroups: ZIO[Any, AwsError, List[
      zio.aws.wafv2.model.FirewallManagerRuleGroup.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "postProcessFirewallManagerRuleGroups",
      postProcessFirewallManagerRuleGroups
    )
    def getManagedByFirewallManager: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("managedByFirewallManager", managedByFirewallManager)
    def getLabelNamespace: ZIO[Any, AwsError, LabelName] =
      AwsError.unwrapOptionField("labelNamespace", labelNamespace)
    def getCustomResponseBodies: ZIO[Any, AwsError, Map[
      EntityName,
      zio.aws.wafv2.model.CustomResponseBody.ReadOnly
    ]] =
      AwsError.unwrapOptionField("customResponseBodies", customResponseBodies)
    def getCaptchaConfig
        : ZIO[Any, AwsError, zio.aws.wafv2.model.CaptchaConfig.ReadOnly] =
      AwsError.unwrapOptionField("captchaConfig", captchaConfig)
    def getChallengeConfig
        : ZIO[Any, AwsError, zio.aws.wafv2.model.ChallengeConfig.ReadOnly] =
      AwsError.unwrapOptionField("challengeConfig", challengeConfig)
    def getTokenDomains: ZIO[Any, AwsError, List[TokenDomain]] =
      AwsError.unwrapOptionField("tokenDomains", tokenDomains)
    def getAssociationConfig
        : ZIO[Any, AwsError, zio.aws.wafv2.model.AssociationConfig.ReadOnly] =
      AwsError.unwrapOptionField("associationConfig", associationConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.WebACL
  ) extends zio.aws.wafv2.model.WebACL.ReadOnly {
    override val name: EntityName =
      zio.aws.wafv2.model.primitives.EntityName(impl.name())
    override val id: EntityId =
      zio.aws.wafv2.model.primitives.EntityId(impl.id())
    override val arn: ResourceArn =
      zio.aws.wafv2.model.primitives.ResourceArn(impl.arn())
    override val defaultAction: zio.aws.wafv2.model.DefaultAction.ReadOnly =
      zio.aws.wafv2.model.DefaultAction.wrap(impl.defaultAction())
    override val description: Optional[EntityDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.wafv2.model.primitives.EntityDescription(value))
    override val rules: Optional[List[zio.aws.wafv2.model.Rule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.Rule.wrap(item)
          }.toList
        )
    override val visibilityConfig
        : zio.aws.wafv2.model.VisibilityConfig.ReadOnly =
      zio.aws.wafv2.model.VisibilityConfig.wrap(impl.visibilityConfig())
    override val capacity: Optional[ConsumedCapacity] = zio.aws.core.internal
      .optionalFromNullable(impl.capacity())
      .map(value => zio.aws.wafv2.model.primitives.ConsumedCapacity(value))
    override val preProcessFirewallManagerRuleGroups: Optional[
      List[zio.aws.wafv2.model.FirewallManagerRuleGroup.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.preProcessFirewallManagerRuleGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wafv2.model.FirewallManagerRuleGroup.wrap(item)
        }.toList
      )
    override val postProcessFirewallManagerRuleGroups: Optional[
      List[zio.aws.wafv2.model.FirewallManagerRuleGroup.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.postProcessFirewallManagerRuleGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wafv2.model.FirewallManagerRuleGroup.wrap(item)
        }.toList
      )
    override val managedByFirewallManager: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.managedByFirewallManager())
        .map(value => value: Boolean)
    override val labelNamespace: Optional[LabelName] = zio.aws.core.internal
      .optionalFromNullable(impl.labelNamespace())
      .map(value => zio.aws.wafv2.model.primitives.LabelName(value))
    override val customResponseBodies: Optional[
      Map[EntityName, zio.aws.wafv2.model.CustomResponseBody.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customResponseBodies())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.wafv2.model.primitives.EntityName(
              key
            ) -> zio.aws.wafv2.model.CustomResponseBody.wrap(value)
          })
          .toMap
      )
    override val captchaConfig
        : Optional[zio.aws.wafv2.model.CaptchaConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.captchaConfig())
        .map(value => zio.aws.wafv2.model.CaptchaConfig.wrap(value))
    override val challengeConfig
        : Optional[zio.aws.wafv2.model.ChallengeConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.challengeConfig())
        .map(value => zio.aws.wafv2.model.ChallengeConfig.wrap(value))
    override val tokenDomains: Optional[List[TokenDomain]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tokenDomains())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.primitives.TokenDomain(item)
          }.toList
        )
    override val associationConfig
        : Optional[zio.aws.wafv2.model.AssociationConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associationConfig())
        .map(value => zio.aws.wafv2.model.AssociationConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.WebACL
  ): zio.aws.wafv2.model.WebACL.ReadOnly = new Wrapper(impl)
}
