package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wafv2.model.primitives.{
  LockToken,
  EntityId,
  ResourceArn,
  EntityDescription,
  EntityName
}
import scala.jdk.CollectionConverters.*
final case class WebACLSummary(
    name: Optional[EntityName] = Optional.Absent,
    id: Optional[EntityId] = Optional.Absent,
    description: Optional[EntityDescription] = Optional.Absent,
    lockToken: Optional[LockToken] = Optional.Absent,
    arn: Optional[ResourceArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.WebACLSummary = {
    import WebACLSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.WebACLSummary
      .builder()
      .optionallyWith(
        name.map(value => EntityName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        id.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        description.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        lockToken.map(value => LockToken.unwrap(value): java.lang.String)
      )(_.lockToken)
      .optionallyWith(
        arn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.WebACLSummary.ReadOnly =
    zio.aws.wafv2.model.WebACLSummary.wrap(buildAwsValue())
}
object WebACLSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.WebACLSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.WebACLSummary =
      zio.aws.wafv2.model.WebACLSummary(
        name.map(value => value),
        id.map(value => value),
        description.map(value => value),
        lockToken.map(value => value),
        arn.map(value => value)
      )
    def name: Optional[EntityName]
    def id: Optional[EntityId]
    def description: Optional[EntityDescription]
    def lockToken: Optional[LockToken]
    def arn: Optional[ResourceArn]
    def getName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("name", name)
    def getId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("id", id)
    def getDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField("description", description)
    def getLockToken: ZIO[Any, AwsError, LockToken] =
      AwsError.unwrapOptionField("lockToken", lockToken)
    def getArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.WebACLSummary
  ) extends zio.aws.wafv2.model.WebACLSummary.ReadOnly {
    override val name: Optional[EntityName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.wafv2.model.primitives.EntityName(value))
    override val id: Optional[EntityId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.wafv2.model.primitives.EntityId(value))
    override val description: Optional[EntityDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.wafv2.model.primitives.EntityDescription(value))
    override val lockToken: Optional[LockToken] = zio.aws.core.internal
      .optionalFromNullable(impl.lockToken())
      .map(value => zio.aws.wafv2.model.primitives.LockToken(value))
    override val arn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.wafv2.model.primitives.ResourceArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.WebACLSummary
  ): zio.aws.wafv2.model.WebACLSummary.ReadOnly = new Wrapper(impl)
}
