package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wisdom.model.primitives.{
  TagValue,
  Description,
  ClientToken,
  Name,
  TagKey
}
import scala.jdk.CollectionConverters.*
final case class CreateAssistantRequest(
    clientToken: Option[ClientToken] = None,
    description: Option[Description] = None,
    name: Name,
    serverSideEncryptionConfiguration: Option[
      zio.aws.wisdom.model.ServerSideEncryptionConfiguration
    ] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    `type`: zio.aws.wisdom.model.AssistantType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.CreateAssistantRequest = {
    import CreateAssistantRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.CreateAssistantRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        serverSideEncryptionConfiguration.map(value => value.buildAwsValue())
      )(_.serverSideEncryptionConfiguration)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.CreateAssistantRequest.ReadOnly =
    zio.aws.wisdom.model.CreateAssistantRequest.wrap(buildAwsValue())
}
object CreateAssistantRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.CreateAssistantRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.CreateAssistantRequest =
      zio.aws.wisdom.model.CreateAssistantRequest(
        clientToken.map(value => value),
        description.map(value => value),
        name,
        serverSideEncryptionConfiguration.map(value => value.asEditable),
        tags.map(value => value),
        `type`
      )
    def clientToken: Option[ClientToken]
    def description: Option[Description]
    def name: Name
    def serverSideEncryptionConfiguration: Option[
      zio.aws.wisdom.model.ServerSideEncryptionConfiguration.ReadOnly
    ]
    def tags: Option[Map[TagKey, TagValue]]
    def `type`: zio.aws.wisdom.model.AssistantType
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getServerSideEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.wisdom.model.ServerSideEncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serverSideEncryptionConfiguration",
      serverSideEncryptionConfiguration
    )
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getType: ZIO[Any, Nothing, zio.aws.wisdom.model.AssistantType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.CreateAssistantRequest
  ) extends zio.aws.wisdom.model.CreateAssistantRequest.ReadOnly {
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.wisdom.model.primitives.ClientToken(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.wisdom.model.primitives.Description(value))
    override val name: Name = zio.aws.wisdom.model.primitives.Name(impl.name())
    override val serverSideEncryptionConfiguration: Option[
      zio.aws.wisdom.model.ServerSideEncryptionConfiguration.ReadOnly
    ] = scala
      .Option(impl.serverSideEncryptionConfiguration())
      .map(value =>
        zio.aws.wisdom.model.ServerSideEncryptionConfiguration.wrap(value)
      )
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.wisdom.model.primitives
              .TagKey(key) -> zio.aws.wisdom.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val `type`: zio.aws.wisdom.model.AssistantType =
      zio.aws.wisdom.model.AssistantType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.CreateAssistantRequest
  ): zio.aws.wisdom.model.CreateAssistantRequest.ReadOnly = new Wrapper(impl)
}
