package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wisdom.model.primitives.UuidOrArn
import scala.jdk.CollectionConverters.*
final case class DeleteContentRequest(
    contentId: UuidOrArn,
    knowledgeBaseId: UuidOrArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.DeleteContentRequest = {
    import DeleteContentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.DeleteContentRequest
      .builder()
      .contentId(UuidOrArn.unwrap(contentId): java.lang.String)
      .knowledgeBaseId(UuidOrArn.unwrap(knowledgeBaseId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.DeleteContentRequest.ReadOnly =
    zio.aws.wisdom.model.DeleteContentRequest.wrap(buildAwsValue())
}
object DeleteContentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.DeleteContentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.DeleteContentRequest =
      zio.aws.wisdom.model.DeleteContentRequest(contentId, knowledgeBaseId)
    def contentId: UuidOrArn
    def knowledgeBaseId: UuidOrArn
    def getContentId: ZIO[Any, Nothing, UuidOrArn] = ZIO.succeed(contentId)
    def getKnowledgeBaseId: ZIO[Any, Nothing, UuidOrArn] =
      ZIO.succeed(knowledgeBaseId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.DeleteContentRequest
  ) extends zio.aws.wisdom.model.DeleteContentRequest.ReadOnly {
    override val contentId: UuidOrArn =
      zio.aws.wisdom.model.primitives.UuidOrArn(impl.contentId())
    override val knowledgeBaseId: UuidOrArn =
      zio.aws.wisdom.model.primitives.UuidOrArn(impl.knowledgeBaseId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.DeleteContentRequest
  ): zio.aws.wisdom.model.DeleteContentRequest.ReadOnly = new Wrapper(impl)
}
