package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wisdom.model.primitives.UuidOrArn
import scala.jdk.CollectionConverters.*
final case class DeleteKnowledgeBaseRequest(knowledgeBaseId: UuidOrArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.DeleteKnowledgeBaseRequest = {
    import DeleteKnowledgeBaseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.DeleteKnowledgeBaseRequest
      .builder()
      .knowledgeBaseId(UuidOrArn.unwrap(knowledgeBaseId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.DeleteKnowledgeBaseRequest.ReadOnly =
    zio.aws.wisdom.model.DeleteKnowledgeBaseRequest.wrap(buildAwsValue())
}
object DeleteKnowledgeBaseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.DeleteKnowledgeBaseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.DeleteKnowledgeBaseRequest =
      zio.aws.wisdom.model.DeleteKnowledgeBaseRequest(knowledgeBaseId)
    def knowledgeBaseId: UuidOrArn
    def getKnowledgeBaseId: ZIO[Any, Nothing, UuidOrArn] =
      ZIO.succeed(knowledgeBaseId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.DeleteKnowledgeBaseRequest
  ) extends zio.aws.wisdom.model.DeleteKnowledgeBaseRequest.ReadOnly {
    override val knowledgeBaseId: UuidOrArn =
      zio.aws.wisdom.model.primitives.UuidOrArn(impl.knowledgeBaseId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.DeleteKnowledgeBaseRequest
  ): zio.aws.wisdom.model.DeleteKnowledgeBaseRequest.ReadOnly = new Wrapper(
    impl
  )
}
