package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Document(
    contentReference: zio.aws.wisdom.model.ContentReference,
    excerpt: Option[zio.aws.wisdom.model.DocumentText] = None,
    title: Option[zio.aws.wisdom.model.DocumentText] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.wisdom.model.Document = {
    import Document.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.Document
      .builder()
      .contentReference(contentReference.buildAwsValue())
      .optionallyWith(excerpt.map(value => value.buildAwsValue()))(_.excerpt)
      .optionallyWith(title.map(value => value.buildAwsValue()))(_.title)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.Document.ReadOnly =
    zio.aws.wisdom.model.Document.wrap(buildAwsValue())
}
object Document {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.wisdom.model.Document] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.Document =
      zio.aws.wisdom.model.Document(
        contentReference.asEditable,
        excerpt.map(value => value.asEditable),
        title.map(value => value.asEditable)
      )
    def contentReference: zio.aws.wisdom.model.ContentReference.ReadOnly
    def excerpt: Option[zio.aws.wisdom.model.DocumentText.ReadOnly]
    def title: Option[zio.aws.wisdom.model.DocumentText.ReadOnly]
    def getContentReference
        : ZIO[Any, Nothing, zio.aws.wisdom.model.ContentReference.ReadOnly] =
      ZIO.succeed(contentReference)
    def getExcerpt
        : ZIO[Any, AwsError, zio.aws.wisdom.model.DocumentText.ReadOnly] =
      AwsError.unwrapOptionField("excerpt", excerpt)
    def getTitle
        : ZIO[Any, AwsError, zio.aws.wisdom.model.DocumentText.ReadOnly] =
      AwsError.unwrapOptionField("title", title)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.Document
  ) extends zio.aws.wisdom.model.Document.ReadOnly {
    override val contentReference
        : zio.aws.wisdom.model.ContentReference.ReadOnly =
      zio.aws.wisdom.model.ContentReference.wrap(impl.contentReference())
    override val excerpt: Option[zio.aws.wisdom.model.DocumentText.ReadOnly] =
      scala
        .Option(impl.excerpt())
        .map(value => zio.aws.wisdom.model.DocumentText.wrap(value))
    override val title: Option[zio.aws.wisdom.model.DocumentText.ReadOnly] =
      scala
        .Option(impl.title())
        .map(value => zio.aws.wisdom.model.DocumentText.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.Document
  ): zio.aws.wisdom.model.Document.ReadOnly = new Wrapper(impl)
}
