package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wisdom.model.primitives.UuidOrArn
import scala.jdk.CollectionConverters.*
final case class GetContentRequest(
    contentId: UuidOrArn,
    knowledgeBaseId: UuidOrArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.GetContentRequest = {
    import GetContentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.GetContentRequest
      .builder()
      .contentId(UuidOrArn.unwrap(contentId): java.lang.String)
      .knowledgeBaseId(UuidOrArn.unwrap(knowledgeBaseId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.GetContentRequest.ReadOnly =
    zio.aws.wisdom.model.GetContentRequest.wrap(buildAwsValue())
}
object GetContentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.GetContentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.GetContentRequest =
      zio.aws.wisdom.model.GetContentRequest(contentId, knowledgeBaseId)
    def contentId: UuidOrArn
    def knowledgeBaseId: UuidOrArn
    def getContentId: ZIO[Any, Nothing, UuidOrArn] = ZIO.succeed(contentId)
    def getKnowledgeBaseId: ZIO[Any, Nothing, UuidOrArn] =
      ZIO.succeed(knowledgeBaseId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.GetContentRequest
  ) extends zio.aws.wisdom.model.GetContentRequest.ReadOnly {
    override val contentId: UuidOrArn =
      zio.aws.wisdom.model.primitives.UuidOrArn(impl.contentId())
    override val knowledgeBaseId: UuidOrArn =
      zio.aws.wisdom.model.primitives.UuidOrArn(impl.knowledgeBaseId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.GetContentRequest
  ): zio.aws.wisdom.model.GetContentRequest.ReadOnly = new Wrapper(impl)
}
