package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wisdom.model.primitives.UuidOrArn
import scala.jdk.CollectionConverters.*
final case class GetContentSummaryRequest(
    contentId: UuidOrArn,
    knowledgeBaseId: UuidOrArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.GetContentSummaryRequest = {
    import GetContentSummaryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.GetContentSummaryRequest
      .builder()
      .contentId(UuidOrArn.unwrap(contentId): java.lang.String)
      .knowledgeBaseId(UuidOrArn.unwrap(knowledgeBaseId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.GetContentSummaryRequest.ReadOnly =
    zio.aws.wisdom.model.GetContentSummaryRequest.wrap(buildAwsValue())
}
object GetContentSummaryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.GetContentSummaryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.GetContentSummaryRequest =
      zio.aws.wisdom.model.GetContentSummaryRequest(contentId, knowledgeBaseId)
    def contentId: UuidOrArn
    def knowledgeBaseId: UuidOrArn
    def getContentId: ZIO[Any, Nothing, UuidOrArn] = ZIO.succeed(contentId)
    def getKnowledgeBaseId: ZIO[Any, Nothing, UuidOrArn] =
      ZIO.succeed(knowledgeBaseId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.GetContentSummaryRequest
  ) extends zio.aws.wisdom.model.GetContentSummaryRequest.ReadOnly {
    override val contentId: UuidOrArn =
      zio.aws.wisdom.model.primitives.UuidOrArn(impl.contentId())
    override val knowledgeBaseId: UuidOrArn =
      zio.aws.wisdom.model.primitives.UuidOrArn(impl.knowledgeBaseId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.GetContentSummaryRequest
  ): zio.aws.wisdom.model.GetContentSummaryRequest.ReadOnly = new Wrapper(impl)
}
