package zio.aws.wisdom.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wisdom.model.primitives.{WaitTimeSeconds, MaxResults, UuidOrArn}
import scala.jdk.CollectionConverters.*
final case class GetRecommendationsRequest(
    assistantId: UuidOrArn,
    maxResults: Option[MaxResults] = None,
    sessionId: UuidOrArn,
    waitTimeSeconds: Option[WaitTimeSeconds] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.GetRecommendationsRequest = {
    import GetRecommendationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.GetRecommendationsRequest
      .builder()
      .assistantId(UuidOrArn.unwrap(assistantId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .sessionId(UuidOrArn.unwrap(sessionId): java.lang.String)
      .optionallyWith(
        waitTimeSeconds.map(value => WaitTimeSeconds.unwrap(value): Integer)
      )(_.waitTimeSeconds)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.GetRecommendationsRequest.ReadOnly =
    zio.aws.wisdom.model.GetRecommendationsRequest.wrap(buildAwsValue())
}
object GetRecommendationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.GetRecommendationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.GetRecommendationsRequest =
      zio.aws.wisdom.model.GetRecommendationsRequest(
        assistantId,
        maxResults.map(value => value),
        sessionId,
        waitTimeSeconds.map(value => value)
      )
    def assistantId: UuidOrArn
    def maxResults: Option[MaxResults]
    def sessionId: UuidOrArn
    def waitTimeSeconds: Option[WaitTimeSeconds]
    def getAssistantId: ZIO[Any, Nothing, UuidOrArn] = ZIO.succeed(assistantId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getSessionId: ZIO[Any, Nothing, UuidOrArn] = ZIO.succeed(sessionId)
    def getWaitTimeSeconds: ZIO[Any, AwsError, WaitTimeSeconds] =
      AwsError.unwrapOptionField("waitTimeSeconds", waitTimeSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.GetRecommendationsRequest
  ) extends zio.aws.wisdom.model.GetRecommendationsRequest.ReadOnly {
    override val assistantId: UuidOrArn =
      zio.aws.wisdom.model.primitives.UuidOrArn(impl.assistantId())
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.wisdom.model.primitives.MaxResults(value))
    override val sessionId: UuidOrArn =
      zio.aws.wisdom.model.primitives.UuidOrArn(impl.sessionId())
    override val waitTimeSeconds: Option[WaitTimeSeconds] = scala
      .Option(impl.waitTimeSeconds())
      .map(value => zio.aws.wisdom.model.primitives.WaitTimeSeconds(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.GetRecommendationsRequest
  ): zio.aws.wisdom.model.GetRecommendationsRequest.ReadOnly = new Wrapper(impl)
}
