package zio.aws.wisdom.model
import scala.jdk.CollectionConverters.*
sealed trait KnowledgeBaseStatus {
  def unwrap: software.amazon.awssdk.services.wisdom.model.KnowledgeBaseStatus
}
object KnowledgeBaseStatus {
  def wrap(
      value: software.amazon.awssdk.services.wisdom.model.KnowledgeBaseStatus
  ): zio.aws.wisdom.model.KnowledgeBaseStatus = value match {
    case software.amazon.awssdk.services.wisdom.model.KnowledgeBaseStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.wisdom.model.KnowledgeBaseStatus.CREATE_IN_PROGRESS =>
      val r = CREATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.wisdom.model.KnowledgeBaseStatus.CREATE_FAILED =>
      val r = CREATE_FAILED
      r
    case software.amazon.awssdk.services.wisdom.model.KnowledgeBaseStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.wisdom.model.KnowledgeBaseStatus.DELETE_IN_PROGRESS =>
      val r = DELETE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.wisdom.model.KnowledgeBaseStatus.DELETE_FAILED =>
      val r = DELETE_FAILED
      r
    case software.amazon.awssdk.services.wisdom.model.KnowledgeBaseStatus.DELETED =>
      val r = DELETED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.wisdom.model.KnowledgeBaseStatus {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.KnowledgeBaseStatus =
      software.amazon.awssdk.services.wisdom.model.KnowledgeBaseStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATE_IN_PROGRESS
      extends zio.aws.wisdom.model.KnowledgeBaseStatus {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.KnowledgeBaseStatus =
      software.amazon.awssdk.services.wisdom.model.KnowledgeBaseStatus.CREATE_IN_PROGRESS
  }
  case object CREATE_FAILED extends zio.aws.wisdom.model.KnowledgeBaseStatus {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.KnowledgeBaseStatus =
      software.amazon.awssdk.services.wisdom.model.KnowledgeBaseStatus.CREATE_FAILED
  }
  case object ACTIVE extends zio.aws.wisdom.model.KnowledgeBaseStatus {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.KnowledgeBaseStatus =
      software.amazon.awssdk.services.wisdom.model.KnowledgeBaseStatus.ACTIVE
  }
  case object DELETE_IN_PROGRESS
      extends zio.aws.wisdom.model.KnowledgeBaseStatus {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.KnowledgeBaseStatus =
      software.amazon.awssdk.services.wisdom.model.KnowledgeBaseStatus.DELETE_IN_PROGRESS
  }
  case object DELETE_FAILED extends zio.aws.wisdom.model.KnowledgeBaseStatus {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.KnowledgeBaseStatus =
      software.amazon.awssdk.services.wisdom.model.KnowledgeBaseStatus.DELETE_FAILED
  }
  case object DELETED extends zio.aws.wisdom.model.KnowledgeBaseStatus {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.KnowledgeBaseStatus =
      software.amazon.awssdk.services.wisdom.model.KnowledgeBaseStatus.DELETED
  }
}
