package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wisdom.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListAssistantAssociationsResponse(
    assistantAssociationSummaries: Iterable[
      zio.aws.wisdom.model.AssistantAssociationSummary
    ],
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.ListAssistantAssociationsResponse = {
    import ListAssistantAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.ListAssistantAssociationsResponse
      .builder()
      .assistantAssociationSummaries(assistantAssociationSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.wisdom.model.ListAssistantAssociationsResponse.ReadOnly =
    zio.aws.wisdom.model.ListAssistantAssociationsResponse.wrap(buildAwsValue())
}
object ListAssistantAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.ListAssistantAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.ListAssistantAssociationsResponse =
      zio.aws.wisdom.model.ListAssistantAssociationsResponse(
        assistantAssociationSummaries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def assistantAssociationSummaries
        : List[zio.aws.wisdom.model.AssistantAssociationSummary.ReadOnly]
    def nextToken: Option[NextToken]
    def getAssistantAssociationSummaries: ZIO[Any, Nothing, List[
      zio.aws.wisdom.model.AssistantAssociationSummary.ReadOnly
    ]] = ZIO.succeed(assistantAssociationSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.ListAssistantAssociationsResponse
  ) extends zio.aws.wisdom.model.ListAssistantAssociationsResponse.ReadOnly {
    override val assistantAssociationSummaries
        : List[zio.aws.wisdom.model.AssistantAssociationSummary.ReadOnly] = impl
      .assistantAssociationSummaries()
      .asScala
      .map { item =>
        zio.aws.wisdom.model.AssistantAssociationSummary.wrap(item)
      }
      .toList
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.wisdom.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.ListAssistantAssociationsResponse
  ): zio.aws.wisdom.model.ListAssistantAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
