package zio.aws.wisdom.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wisdom.model.primitives.{NextToken, MaxResults, UuidOrArn}
import scala.jdk.CollectionConverters.*
final case class ListContentsRequest(
    knowledgeBaseId: UuidOrArn,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.ListContentsRequest = {
    import ListContentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.ListContentsRequest
      .builder()
      .knowledgeBaseId(UuidOrArn.unwrap(knowledgeBaseId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.ListContentsRequest.ReadOnly =
    zio.aws.wisdom.model.ListContentsRequest.wrap(buildAwsValue())
}
object ListContentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.ListContentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.ListContentsRequest =
      zio.aws.wisdom.model.ListContentsRequest(
        knowledgeBaseId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def knowledgeBaseId: UuidOrArn
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getKnowledgeBaseId: ZIO[Any, Nothing, UuidOrArn] =
      ZIO.succeed(knowledgeBaseId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.ListContentsRequest
  ) extends zio.aws.wisdom.model.ListContentsRequest.ReadOnly {
    override val knowledgeBaseId: UuidOrArn =
      zio.aws.wisdom.model.primitives.UuidOrArn(impl.knowledgeBaseId())
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.wisdom.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.wisdom.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.ListContentsRequest
  ): zio.aws.wisdom.model.ListContentsRequest.ReadOnly = new Wrapper(impl)
}
