package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wisdom.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListContentsResponse(
    contentSummaries: Iterable[zio.aws.wisdom.model.ContentSummary],
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.ListContentsResponse = {
    import ListContentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.ListContentsResponse
      .builder()
      .contentSummaries(contentSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.ListContentsResponse.ReadOnly =
    zio.aws.wisdom.model.ListContentsResponse.wrap(buildAwsValue())
}
object ListContentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.ListContentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.ListContentsResponse =
      zio.aws.wisdom.model.ListContentsResponse(
        contentSummaries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def contentSummaries: List[zio.aws.wisdom.model.ContentSummary.ReadOnly]
    def nextToken: Option[NextToken]
    def getContentSummaries: ZIO[Any, Nothing, List[
      zio.aws.wisdom.model.ContentSummary.ReadOnly
    ]] = ZIO.succeed(contentSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.ListContentsResponse
  ) extends zio.aws.wisdom.model.ListContentsResponse.ReadOnly {
    override val contentSummaries
        : List[zio.aws.wisdom.model.ContentSummary.ReadOnly] = impl
      .contentSummaries()
      .asScala
      .map { item =>
        zio.aws.wisdom.model.ContentSummary.wrap(item)
      }
      .toList
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.wisdom.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.ListContentsResponse
  ): zio.aws.wisdom.model.ListContentsResponse.ReadOnly = new Wrapper(impl)
}
