package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class NotifyRecommendationsReceivedResponse(
    errors: Option[
      Iterable[zio.aws.wisdom.model.NotifyRecommendationsReceivedError]
    ] = None,
    recommendationIds: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.NotifyRecommendationsReceivedResponse = {
    import NotifyRecommendationsReceivedResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.NotifyRecommendationsReceivedResponse
      .builder()
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .optionallyWith(
        recommendationIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.recommendationIds)
      .build()
  }
  def asReadOnly
      : zio.aws.wisdom.model.NotifyRecommendationsReceivedResponse.ReadOnly =
    zio.aws.wisdom.model.NotifyRecommendationsReceivedResponse
      .wrap(buildAwsValue())
}
object NotifyRecommendationsReceivedResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.NotifyRecommendationsReceivedResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.NotifyRecommendationsReceivedResponse =
      zio.aws.wisdom.model.NotifyRecommendationsReceivedResponse(
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        recommendationIds.map(value => value)
      )
    def errors: Option[
      List[zio.aws.wisdom.model.NotifyRecommendationsReceivedError.ReadOnly]
    ]
    def recommendationIds: Option[List[String]]
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.wisdom.model.NotifyRecommendationsReceivedError.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
    def getRecommendationIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("recommendationIds", recommendationIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.NotifyRecommendationsReceivedResponse
  ) extends zio.aws.wisdom.model.NotifyRecommendationsReceivedResponse.ReadOnly {
    override val errors: Option[
      List[zio.aws.wisdom.model.NotifyRecommendationsReceivedError.ReadOnly]
    ] = scala
      .Option(impl.errors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wisdom.model.NotifyRecommendationsReceivedError.wrap(item)
        }.toList
      )
    override val recommendationIds: Option[List[String]] = scala
      .Option(impl.recommendationIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.NotifyRecommendationsReceivedResponse
  ): zio.aws.wisdom.model.NotifyRecommendationsReceivedResponse.ReadOnly =
    new Wrapper(impl)
}
