package zio.aws.wisdom.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wisdom.model.primitives.{
  QueryText,
  NextToken,
  MaxResults,
  UuidOrArn
}
import scala.jdk.CollectionConverters.*
final case class QueryAssistantRequest(
    assistantId: UuidOrArn,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None,
    queryText: QueryText
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.QueryAssistantRequest = {
    import QueryAssistantRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.QueryAssistantRequest
      .builder()
      .assistantId(UuidOrArn.unwrap(assistantId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .queryText(QueryText.unwrap(queryText): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.QueryAssistantRequest.ReadOnly =
    zio.aws.wisdom.model.QueryAssistantRequest.wrap(buildAwsValue())
}
object QueryAssistantRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.QueryAssistantRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.QueryAssistantRequest =
      zio.aws.wisdom.model.QueryAssistantRequest(
        assistantId,
        maxResults.map(value => value),
        nextToken.map(value => value),
        queryText
      )
    def assistantId: UuidOrArn
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def queryText: QueryText
    def getAssistantId: ZIO[Any, Nothing, UuidOrArn] = ZIO.succeed(assistantId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getQueryText: ZIO[Any, Nothing, QueryText] = ZIO.succeed(queryText)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.QueryAssistantRequest
  ) extends zio.aws.wisdom.model.QueryAssistantRequest.ReadOnly {
    override val assistantId: UuidOrArn =
      zio.aws.wisdom.model.primitives.UuidOrArn(impl.assistantId())
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.wisdom.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.wisdom.model.primitives.NextToken(value))
    override val queryText: QueryText =
      zio.aws.wisdom.model.primitives.QueryText(impl.queryText())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.QueryAssistantRequest
  ): zio.aws.wisdom.model.QueryAssistantRequest.ReadOnly = new Wrapper(impl)
}
