package zio.aws.wisdom.model
import scala.jdk.CollectionConverters.*
sealed trait RelevanceLevel {
  def unwrap: software.amazon.awssdk.services.wisdom.model.RelevanceLevel
}
object RelevanceLevel {
  def wrap(
      value: software.amazon.awssdk.services.wisdom.model.RelevanceLevel
  ): zio.aws.wisdom.model.RelevanceLevel = value match {
    case software.amazon.awssdk.services.wisdom.model.RelevanceLevel.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.wisdom.model.RelevanceLevel.HIGH =>
      val r = HIGH
      r
    case software.amazon.awssdk.services.wisdom.model.RelevanceLevel.MEDIUM =>
      val r = MEDIUM
      r
    case software.amazon.awssdk.services.wisdom.model.RelevanceLevel.LOW =>
      val r = LOW
      r
  }
  case object unknownToSdkVersion extends zio.aws.wisdom.model.RelevanceLevel {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.RelevanceLevel =
      software.amazon.awssdk.services.wisdom.model.RelevanceLevel.UNKNOWN_TO_SDK_VERSION
  }
  case object HIGH extends zio.aws.wisdom.model.RelevanceLevel {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.RelevanceLevel =
      software.amazon.awssdk.services.wisdom.model.RelevanceLevel.HIGH
  }
  case object MEDIUM extends zio.aws.wisdom.model.RelevanceLevel {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.RelevanceLevel =
      software.amazon.awssdk.services.wisdom.model.RelevanceLevel.MEDIUM
  }
  case object LOW extends zio.aws.wisdom.model.RelevanceLevel {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.RelevanceLevel =
      software.amazon.awssdk.services.wisdom.model.RelevanceLevel.LOW
  }
}
