package zio.aws.wisdom.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wisdom.model.primitives.{NextToken, MaxResults, UuidOrArn}
import scala.jdk.CollectionConverters.*
final case class SearchContentRequest(
    knowledgeBaseId: UuidOrArn,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None,
    searchExpression: zio.aws.wisdom.model.SearchExpression
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.SearchContentRequest = {
    import SearchContentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.SearchContentRequest
      .builder()
      .knowledgeBaseId(UuidOrArn.unwrap(knowledgeBaseId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .searchExpression(searchExpression.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.SearchContentRequest.ReadOnly =
    zio.aws.wisdom.model.SearchContentRequest.wrap(buildAwsValue())
}
object SearchContentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.SearchContentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.SearchContentRequest =
      zio.aws.wisdom.model.SearchContentRequest(
        knowledgeBaseId,
        maxResults.map(value => value),
        nextToken.map(value => value),
        searchExpression.asEditable
      )
    def knowledgeBaseId: UuidOrArn
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def searchExpression: zio.aws.wisdom.model.SearchExpression.ReadOnly
    def getKnowledgeBaseId: ZIO[Any, Nothing, UuidOrArn] =
      ZIO.succeed(knowledgeBaseId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSearchExpression
        : ZIO[Any, Nothing, zio.aws.wisdom.model.SearchExpression.ReadOnly] =
      ZIO.succeed(searchExpression)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.SearchContentRequest
  ) extends zio.aws.wisdom.model.SearchContentRequest.ReadOnly {
    override val knowledgeBaseId: UuidOrArn =
      zio.aws.wisdom.model.primitives.UuidOrArn(impl.knowledgeBaseId())
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.wisdom.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.wisdom.model.primitives.NextToken(value))
    override val searchExpression
        : zio.aws.wisdom.model.SearchExpression.ReadOnly =
      zio.aws.wisdom.model.SearchExpression.wrap(impl.searchExpression())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.SearchContentRequest
  ): zio.aws.wisdom.model.SearchContentRequest.ReadOnly = new Wrapper(impl)
}
