package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wisdom.model.primitives.{
  TagValue,
  Arn,
  Uuid,
  Description,
  Name,
  TagKey
}
import scala.jdk.CollectionConverters.*
final case class SessionData(
    description: Option[Description] = None,
    name: Name,
    sessionArn: Arn,
    sessionId: Uuid,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.SessionData = {
    import SessionData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.SessionData
      .builder()
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .name(Name.unwrap(name): java.lang.String)
      .sessionArn(Arn.unwrap(sessionArn): java.lang.String)
      .sessionId(Uuid.unwrap(sessionId): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.SessionData.ReadOnly =
    zio.aws.wisdom.model.SessionData.wrap(buildAwsValue())
}
object SessionData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.SessionData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.SessionData =
      zio.aws.wisdom.model.SessionData(
        description.map(value => value),
        name,
        sessionArn,
        sessionId,
        tags.map(value => value)
      )
    def description: Option[Description]
    def name: Name
    def sessionArn: Arn
    def sessionId: Uuid
    def tags: Option[Map[TagKey, TagValue]]
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getSessionArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(sessionArn)
    def getSessionId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(sessionId)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.SessionData
  ) extends zio.aws.wisdom.model.SessionData.ReadOnly {
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.wisdom.model.primitives.Description(value))
    override val name: Name = zio.aws.wisdom.model.primitives.Name(impl.name())
    override val sessionArn: Arn =
      zio.aws.wisdom.model.primitives.Arn(impl.sessionArn())
    override val sessionId: Uuid =
      zio.aws.wisdom.model.primitives.Uuid(impl.sessionId())
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.wisdom.model.primitives
              .TagKey(key) -> zio.aws.wisdom.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.SessionData
  ): zio.aws.wisdom.model.SessionData.ReadOnly = new Wrapper(impl)
}
