package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wisdom.model.primitives.{Uuid, Arn}
import scala.jdk.CollectionConverters.*
final case class SessionSummary(
    assistantArn: Arn,
    assistantId: Uuid,
    sessionArn: Arn,
    sessionId: Uuid
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.SessionSummary = {
    import SessionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.SessionSummary
      .builder()
      .assistantArn(Arn.unwrap(assistantArn): java.lang.String)
      .assistantId(Uuid.unwrap(assistantId): java.lang.String)
      .sessionArn(Arn.unwrap(sessionArn): java.lang.String)
      .sessionId(Uuid.unwrap(sessionId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.SessionSummary.ReadOnly =
    zio.aws.wisdom.model.SessionSummary.wrap(buildAwsValue())
}
object SessionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.SessionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.SessionSummary = zio.aws.wisdom.model
      .SessionSummary(assistantArn, assistantId, sessionArn, sessionId)
    def assistantArn: Arn
    def assistantId: Uuid
    def sessionArn: Arn
    def sessionId: Uuid
    def getAssistantArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(assistantArn)
    def getAssistantId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(assistantId)
    def getSessionArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(sessionArn)
    def getSessionId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(sessionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.SessionSummary
  ) extends zio.aws.wisdom.model.SessionSummary.ReadOnly {
    override val assistantArn: Arn =
      zio.aws.wisdom.model.primitives.Arn(impl.assistantArn())
    override val assistantId: Uuid =
      zio.aws.wisdom.model.primitives.Uuid(impl.assistantId())
    override val sessionArn: Arn =
      zio.aws.wisdom.model.primitives.Arn(impl.sessionArn())
    override val sessionId: Uuid =
      zio.aws.wisdom.model.primitives.Uuid(impl.sessionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.SessionSummary
  ): zio.aws.wisdom.model.SessionSummary.ReadOnly = new Wrapper(impl)
}
