package zio.aws.wisdom
import zio.aws.wisdom.model.SearchContentResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.wisdom.model.{
  DeleteAssistantAssociationRequest,
  DeleteAssistantAssociationResponse,
  CreateKnowledgeBaseResponse,
  GetContentSummaryRequest,
  CreateSessionResponse,
  KnowledgeBaseSummary,
  ListImportJobsResponse,
  StartImportJobResponse,
  CreateContentResponse,
  SearchContentRequest,
  ListAssistantsResponse,
  GetAssistantResponse,
  SessionSummary,
  QuickResponseSummary,
  DeleteKnowledgeBaseRequest,
  GetContentRequest,
  QuickResponseSearchResultData,
  ListQuickResponsesResponse,
  CreateAssistantAssociationResponse,
  UpdateKnowledgeBaseTemplateUriRequest,
  ListAssistantsRequest,
  DeleteImportJobResponse,
  UpdateContentResponse,
  UpdateContentRequest,
  ListTagsForResourceRequest,
  GetImportJobResponse,
  GetKnowledgeBaseRequest,
  UpdateKnowledgeBaseTemplateUriResponse,
  CreateKnowledgeBaseRequest,
  GetKnowledgeBaseResponse,
  SearchQuickResponsesRequest,
  StartImportJobRequest,
  AssistantAssociationSummary,
  CreateSessionRequest,
  DeleteContentResponse,
  GetContentSummaryResponse,
  ListImportJobsRequest,
  ListTagsForResourceResponse,
  ListKnowledgeBasesRequest,
  UntagResourceResponse,
  CreateAssistantResponse,
  DeleteAssistantResponse,
  GetAssistantAssociationResponse,
  GetAssistantAssociationRequest,
  CreateQuickResponseResponse,
  ListContentsResponse,
  NotifyRecommendationsReceivedRequest,
  GetAssistantRequest,
  UpdateQuickResponseRequest,
  ImportJobSummary,
  ListKnowledgeBasesResponse,
  SearchSessionsRequest,
  DeleteQuickResponseResponse,
  ListAssistantAssociationsRequest,
  StartContentUploadResponse,
  GetSessionRequest,
  GetImportJobRequest,
  SearchContentResponse,
  DeleteContentRequest,
  UntagResourceRequest,
  ListAssistantAssociationsResponse,
  CreateAssistantRequest,
  GetQuickResponseResponse,
  NotifyRecommendationsReceivedResponse,
  UpdateQuickResponseResponse,
  GetSessionResponse,
  DeleteKnowledgeBaseResponse,
  ListQuickResponsesRequest,
  AssistantSummary,
  RemoveKnowledgeBaseTemplateUriResponse,
  SearchSessionsResponse,
  TagResourceResponse,
  SearchQuickResponsesResponse,
  DeleteImportJobRequest,
  RemoveKnowledgeBaseTemplateUriRequest,
  GetContentResponse,
  DeleteQuickResponseRequest,
  StartContentUploadRequest,
  CreateContentRequest,
  ContentSummary,
  ListContentsRequest,
  GetQuickResponseRequest,
  TagResourceRequest,
  CreateAssistantAssociationRequest,
  DeleteAssistantRequest,
  CreateQuickResponseRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.wisdom.paginators.{
  ListQuickResponsesPublisher,
  SearchSessionsPublisher,
  ListAssistantsPublisher,
  ListAssistantAssociationsPublisher,
  ListContentsPublisher,
  ListImportJobsPublisher,
  ListKnowledgeBasesPublisher,
  SearchContentPublisher,
  SearchQuickResponsesPublisher
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import software.amazon.awssdk.services.wisdom.{
  WisdomAsyncClientBuilder,
  WisdomAsyncClient
}
import scala.jdk.CollectionConverters.*
trait Wisdom extends AspectSupport[Wisdom] {
  val api: WisdomAsyncClient
  def getAssistant(
      request: zio.aws.wisdom.model.GetAssistantRequest
  ): IO[AwsError, zio.aws.wisdom.model.GetAssistantResponse.ReadOnly]
  def updateQuickResponse(
      request: zio.aws.wisdom.model.UpdateQuickResponseRequest
  ): IO[AwsError, zio.aws.wisdom.model.UpdateQuickResponseResponse.ReadOnly]
  def startContentUpload(
      request: zio.aws.wisdom.model.StartContentUploadRequest
  ): IO[AwsError, zio.aws.wisdom.model.StartContentUploadResponse.ReadOnly]
  def deleteQuickResponse(
      request: zio.aws.wisdom.model.DeleteQuickResponseRequest
  ): IO[AwsError, zio.aws.wisdom.model.DeleteQuickResponseResponse.ReadOnly]
  def deleteKnowledgeBase(
      request: zio.aws.wisdom.model.DeleteKnowledgeBaseRequest
  ): IO[AwsError, zio.aws.wisdom.model.DeleteKnowledgeBaseResponse.ReadOnly]
  def listImportJobs(
      request: zio.aws.wisdom.model.ListImportJobsRequest
  ): ZStream[Any, AwsError, zio.aws.wisdom.model.ImportJobSummary.ReadOnly]
  def listImportJobsPaginated(
      request: zio.aws.wisdom.model.ListImportJobsRequest
  ): IO[AwsError, zio.aws.wisdom.model.ListImportJobsResponse.ReadOnly]
  def searchSessions(
      request: zio.aws.wisdom.model.SearchSessionsRequest
  ): ZStream[Any, AwsError, zio.aws.wisdom.model.SessionSummary.ReadOnly]
  def searchSessionsPaginated(
      request: zio.aws.wisdom.model.SearchSessionsRequest
  ): IO[AwsError, zio.aws.wisdom.model.SearchSessionsResponse.ReadOnly]
  def getAssistantAssociation(
      request: zio.aws.wisdom.model.GetAssistantAssociationRequest
  ): IO[AwsError, zio.aws.wisdom.model.GetAssistantAssociationResponse.ReadOnly]
  def getContent(
      request: zio.aws.wisdom.model.GetContentRequest
  ): IO[AwsError, zio.aws.wisdom.model.GetContentResponse.ReadOnly]
  def searchContent(
      request: zio.aws.wisdom.model.SearchContentRequest
  ): ZStream[Any, AwsError, zio.aws.wisdom.model.ContentSummary.ReadOnly]
  def searchContentPaginated(
      request: zio.aws.wisdom.model.SearchContentRequest
  ): IO[AwsError, ReadOnly]
  def deleteAssistantAssociation(
      request: zio.aws.wisdom.model.DeleteAssistantAssociationRequest
  ): IO[
    AwsError,
    zio.aws.wisdom.model.DeleteAssistantAssociationResponse.ReadOnly
  ]
  def updateContent(
      request: zio.aws.wisdom.model.UpdateContentRequest
  ): IO[AwsError, zio.aws.wisdom.model.UpdateContentResponse.ReadOnly]
  def startImportJob(
      request: zio.aws.wisdom.model.StartImportJobRequest
  ): IO[AwsError, zio.aws.wisdom.model.StartImportJobResponse.ReadOnly]
  def createQuickResponse(
      request: zio.aws.wisdom.model.CreateQuickResponseRequest
  ): IO[AwsError, zio.aws.wisdom.model.CreateQuickResponseResponse.ReadOnly]
  def updateKnowledgeBaseTemplateUri(
      request: zio.aws.wisdom.model.UpdateKnowledgeBaseTemplateUriRequest
  ): IO[
    AwsError,
    zio.aws.wisdom.model.UpdateKnowledgeBaseTemplateUriResponse.ReadOnly
  ]
  def getContentSummary(
      request: zio.aws.wisdom.model.GetContentSummaryRequest
  ): IO[AwsError, zio.aws.wisdom.model.GetContentSummaryResponse.ReadOnly]
  def getKnowledgeBase(
      request: zio.aws.wisdom.model.GetKnowledgeBaseRequest
  ): IO[AwsError, zio.aws.wisdom.model.GetKnowledgeBaseResponse.ReadOnly]
  def notifyRecommendationsReceived(
      request: zio.aws.wisdom.model.NotifyRecommendationsReceivedRequest
  ): IO[
    AwsError,
    zio.aws.wisdom.model.NotifyRecommendationsReceivedResponse.ReadOnly
  ]
  def searchQuickResponses(
      request: zio.aws.wisdom.model.SearchQuickResponsesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.wisdom.model.QuickResponseSearchResultData.ReadOnly
  ]
  def searchQuickResponsesPaginated(
      request: zio.aws.wisdom.model.SearchQuickResponsesRequest
  ): IO[AwsError, zio.aws.wisdom.model.SearchQuickResponsesResponse.ReadOnly]
  def listAssistantAssociations(
      request: zio.aws.wisdom.model.ListAssistantAssociationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.wisdom.model.AssistantAssociationSummary.ReadOnly
  ]
  def listAssistantAssociationsPaginated(
      request: zio.aws.wisdom.model.ListAssistantAssociationsRequest
  ): IO[
    AwsError,
    zio.aws.wisdom.model.ListAssistantAssociationsResponse.ReadOnly
  ]
  def createContent(
      request: zio.aws.wisdom.model.CreateContentRequest
  ): IO[AwsError, zio.aws.wisdom.model.CreateContentResponse.ReadOnly]
  def createKnowledgeBase(
      request: zio.aws.wisdom.model.CreateKnowledgeBaseRequest
  ): IO[AwsError, zio.aws.wisdom.model.CreateKnowledgeBaseResponse.ReadOnly]
  def listQuickResponses(
      request: zio.aws.wisdom.model.ListQuickResponsesRequest
  ): ZStream[Any, AwsError, zio.aws.wisdom.model.QuickResponseSummary.ReadOnly]
  def listQuickResponsesPaginated(
      request: zio.aws.wisdom.model.ListQuickResponsesRequest
  ): IO[AwsError, zio.aws.wisdom.model.ListQuickResponsesResponse.ReadOnly]
  def untagResource(
      request: zio.aws.wisdom.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.wisdom.model.UntagResourceResponse.ReadOnly]
  def createAssistant(
      request: zio.aws.wisdom.model.CreateAssistantRequest
  ): IO[AwsError, zio.aws.wisdom.model.CreateAssistantResponse.ReadOnly]
  def createAssistantAssociation(
      request: zio.aws.wisdom.model.CreateAssistantAssociationRequest
  ): IO[
    AwsError,
    zio.aws.wisdom.model.CreateAssistantAssociationResponse.ReadOnly
  ]
  def deleteContent(
      request: zio.aws.wisdom.model.DeleteContentRequest
  ): IO[AwsError, zio.aws.wisdom.model.DeleteContentResponse.ReadOnly]
  def listTagsForResource(
      request: zio.aws.wisdom.model.ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.wisdom.model.ListTagsForResourceResponse.ReadOnly]
  def removeKnowledgeBaseTemplateUri(
      request: zio.aws.wisdom.model.RemoveKnowledgeBaseTemplateUriRequest
  ): IO[
    AwsError,
    zio.aws.wisdom.model.RemoveKnowledgeBaseTemplateUriResponse.ReadOnly
  ]
  def tagResource(
      request: zio.aws.wisdom.model.TagResourceRequest
  ): IO[AwsError, zio.aws.wisdom.model.TagResourceResponse.ReadOnly]
  def getImportJob(
      request: zio.aws.wisdom.model.GetImportJobRequest
  ): IO[AwsError, zio.aws.wisdom.model.GetImportJobResponse.ReadOnly]
  def createSession(
      request: zio.aws.wisdom.model.CreateSessionRequest
  ): IO[AwsError, zio.aws.wisdom.model.CreateSessionResponse.ReadOnly]
  def listContents(
      request: zio.aws.wisdom.model.ListContentsRequest
  ): ZStream[Any, AwsError, zio.aws.wisdom.model.ContentSummary.ReadOnly]
  def listContentsPaginated(
      request: zio.aws.wisdom.model.ListContentsRequest
  ): IO[AwsError, zio.aws.wisdom.model.ListContentsResponse.ReadOnly]
  def getSession(
      request: zio.aws.wisdom.model.GetSessionRequest
  ): IO[AwsError, zio.aws.wisdom.model.GetSessionResponse.ReadOnly]
  def deleteImportJob(
      request: zio.aws.wisdom.model.DeleteImportJobRequest
  ): IO[AwsError, zio.aws.wisdom.model.DeleteImportJobResponse.ReadOnly]
  def listAssistants(
      request: zio.aws.wisdom.model.ListAssistantsRequest
  ): ZStream[Any, AwsError, zio.aws.wisdom.model.AssistantSummary.ReadOnly]
  def listAssistantsPaginated(
      request: zio.aws.wisdom.model.ListAssistantsRequest
  ): IO[AwsError, zio.aws.wisdom.model.ListAssistantsResponse.ReadOnly]
  def listKnowledgeBases(
      request: zio.aws.wisdom.model.ListKnowledgeBasesRequest
  ): ZStream[Any, AwsError, zio.aws.wisdom.model.KnowledgeBaseSummary.ReadOnly]
  def listKnowledgeBasesPaginated(
      request: zio.aws.wisdom.model.ListKnowledgeBasesRequest
  ): IO[AwsError, zio.aws.wisdom.model.ListKnowledgeBasesResponse.ReadOnly]
  def deleteAssistant(
      request: zio.aws.wisdom.model.DeleteAssistantRequest
  ): IO[AwsError, zio.aws.wisdom.model.DeleteAssistantResponse.ReadOnly]
  def getQuickResponse(
      request: zio.aws.wisdom.model.GetQuickResponseRequest
  ): IO[AwsError, zio.aws.wisdom.model.GetQuickResponseResponse.ReadOnly]
}
object Wisdom {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Wisdom] = customized(
    identity
  )
  def customized(
      customization: WisdomAsyncClientBuilder => WisdomAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Wisdom] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: WisdomAsyncClientBuilder => WisdomAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Wisdom] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = WisdomAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[WisdomAsyncClient, WisdomAsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[WisdomAsyncClient, WisdomAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new WisdomImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class WisdomImpl[R](
      override val api: WisdomAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Wisdom
      with AwsServiceBase[R] {
    override val serviceName: String = "Wisdom"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): WisdomImpl[R1] = new WisdomImpl(api, newAspect, r)
    def getAssistant(
        request: zio.aws.wisdom.model.GetAssistantRequest
    ): IO[AwsError, zio.aws.wisdom.model.GetAssistantResponse.ReadOnly] =
      asyncRequestResponse[GetAssistantRequest, GetAssistantResponse](
        "getAssistant",
        api.getAssistant
      )(request.buildAwsValue())
        .map(zio.aws.wisdom.model.GetAssistantResponse.wrap)
        .provideEnvironment(r)
    def updateQuickResponse(
        request: zio.aws.wisdom.model.UpdateQuickResponseRequest
    ): IO[AwsError, zio.aws.wisdom.model.UpdateQuickResponseResponse.ReadOnly] =
      asyncRequestResponse[
        UpdateQuickResponseRequest,
        UpdateQuickResponseResponse
      ]("updateQuickResponse", api.updateQuickResponse)(request.buildAwsValue())
        .map(zio.aws.wisdom.model.UpdateQuickResponseResponse.wrap)
        .provideEnvironment(r)
    def startContentUpload(
        request: zio.aws.wisdom.model.StartContentUploadRequest
    ): IO[AwsError, zio.aws.wisdom.model.StartContentUploadResponse.ReadOnly] =
      asyncRequestResponse[
        StartContentUploadRequest,
        StartContentUploadResponse
      ]("startContentUpload", api.startContentUpload)(request.buildAwsValue())
        .map(zio.aws.wisdom.model.StartContentUploadResponse.wrap)
        .provideEnvironment(r)
    def deleteQuickResponse(
        request: zio.aws.wisdom.model.DeleteQuickResponseRequest
    ): IO[AwsError, zio.aws.wisdom.model.DeleteQuickResponseResponse.ReadOnly] =
      asyncRequestResponse[
        DeleteQuickResponseRequest,
        DeleteQuickResponseResponse
      ]("deleteQuickResponse", api.deleteQuickResponse)(request.buildAwsValue())
        .map(zio.aws.wisdom.model.DeleteQuickResponseResponse.wrap)
        .provideEnvironment(r)
    def deleteKnowledgeBase(
        request: zio.aws.wisdom.model.DeleteKnowledgeBaseRequest
    ): IO[AwsError, zio.aws.wisdom.model.DeleteKnowledgeBaseResponse.ReadOnly] =
      asyncRequestResponse[
        DeleteKnowledgeBaseRequest,
        DeleteKnowledgeBaseResponse
      ]("deleteKnowledgeBase", api.deleteKnowledgeBase)(request.buildAwsValue())
        .map(zio.aws.wisdom.model.DeleteKnowledgeBaseResponse.wrap)
        .provideEnvironment(r)
    def listImportJobs(
        request: zio.aws.wisdom.model.ListImportJobsRequest
    ): ZStream[Any, AwsError, zio.aws.wisdom.model.ImportJobSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListImportJobsRequest,
        ImportJobSummary,
        ListImportJobsPublisher
      ]("listImportJobs", api.listImportJobsPaginator, _.importJobSummaries())(
        request.buildAwsValue()
      ).map(item => zio.aws.wisdom.model.ImportJobSummary.wrap(item))
        .provideEnvironment(r)
    def listImportJobsPaginated(
        request: zio.aws.wisdom.model.ListImportJobsRequest
    ): IO[AwsError, zio.aws.wisdom.model.ListImportJobsResponse.ReadOnly] =
      asyncRequestResponse[ListImportJobsRequest, ListImportJobsResponse](
        "listImportJobs",
        api.listImportJobs
      )(request.buildAwsValue())
        .map(zio.aws.wisdom.model.ListImportJobsResponse.wrap)
        .provideEnvironment(r)
    def searchSessions(
        request: zio.aws.wisdom.model.SearchSessionsRequest
    ): ZStream[Any, AwsError, zio.aws.wisdom.model.SessionSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        SearchSessionsRequest,
        SessionSummary,
        SearchSessionsPublisher
      ]("searchSessions", api.searchSessionsPaginator, _.sessionSummaries())(
        request.buildAwsValue()
      ).map(item => zio.aws.wisdom.model.SessionSummary.wrap(item))
        .provideEnvironment(r)
    def searchSessionsPaginated(
        request: zio.aws.wisdom.model.SearchSessionsRequest
    ): IO[AwsError, zio.aws.wisdom.model.SearchSessionsResponse.ReadOnly] =
      asyncRequestResponse[SearchSessionsRequest, SearchSessionsResponse](
        "searchSessions",
        api.searchSessions
      )(request.buildAwsValue())
        .map(zio.aws.wisdom.model.SearchSessionsResponse.wrap)
        .provideEnvironment(r)
    def getAssistantAssociation(
        request: zio.aws.wisdom.model.GetAssistantAssociationRequest
    ): IO[
      AwsError,
      zio.aws.wisdom.model.GetAssistantAssociationResponse.ReadOnly
    ] = asyncRequestResponse[
      GetAssistantAssociationRequest,
      GetAssistantAssociationResponse
    ]("getAssistantAssociation", api.getAssistantAssociation)(
      request.buildAwsValue()
    ).map(zio.aws.wisdom.model.GetAssistantAssociationResponse.wrap)
      .provideEnvironment(r)
    def getContent(
        request: zio.aws.wisdom.model.GetContentRequest
    ): IO[AwsError, zio.aws.wisdom.model.GetContentResponse.ReadOnly] =
      asyncRequestResponse[GetContentRequest, GetContentResponse](
        "getContent",
        api.getContent
      )(request.buildAwsValue())
        .map(zio.aws.wisdom.model.GetContentResponse.wrap)
        .provideEnvironment(r)
    def searchContent(
        request: zio.aws.wisdom.model.SearchContentRequest
    ): ZStream[Any, AwsError, zio.aws.wisdom.model.ContentSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        SearchContentRequest,
        ContentSummary,
        SearchContentPublisher
      ]("searchContent", api.searchContentPaginator, _.contentSummaries())(
        request.buildAwsValue()
      ).map(item => zio.aws.wisdom.model.ContentSummary.wrap(item))
        .provideEnvironment(r)
    def searchContentPaginated(
        request: zio.aws.wisdom.model.SearchContentRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[SearchContentRequest, SearchContentResponse](
        "searchContent",
        api.searchContent
      )(request.buildAwsValue())
        .map(zio.aws.wisdom.model.SearchContentResponse.wrap)
        .provideEnvironment(r)
    def deleteAssistantAssociation(
        request: zio.aws.wisdom.model.DeleteAssistantAssociationRequest
    ): IO[
      AwsError,
      zio.aws.wisdom.model.DeleteAssistantAssociationResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteAssistantAssociationRequest,
      DeleteAssistantAssociationResponse
    ]("deleteAssistantAssociation", api.deleteAssistantAssociation)(
      request.buildAwsValue()
    ).map(zio.aws.wisdom.model.DeleteAssistantAssociationResponse.wrap)
      .provideEnvironment(r)
    def updateContent(
        request: zio.aws.wisdom.model.UpdateContentRequest
    ): IO[AwsError, zio.aws.wisdom.model.UpdateContentResponse.ReadOnly] =
      asyncRequestResponse[UpdateContentRequest, UpdateContentResponse](
        "updateContent",
        api.updateContent
      )(request.buildAwsValue())
        .map(zio.aws.wisdom.model.UpdateContentResponse.wrap)
        .provideEnvironment(r)
    def startImportJob(
        request: zio.aws.wisdom.model.StartImportJobRequest
    ): IO[AwsError, zio.aws.wisdom.model.StartImportJobResponse.ReadOnly] =
      asyncRequestResponse[StartImportJobRequest, StartImportJobResponse](
        "startImportJob",
        api.startImportJob
      )(request.buildAwsValue())
        .map(zio.aws.wisdom.model.StartImportJobResponse.wrap)
        .provideEnvironment(r)
    def createQuickResponse(
        request: zio.aws.wisdom.model.CreateQuickResponseRequest
    ): IO[AwsError, zio.aws.wisdom.model.CreateQuickResponseResponse.ReadOnly] =
      asyncRequestResponse[
        CreateQuickResponseRequest,
        CreateQuickResponseResponse
      ]("createQuickResponse", api.createQuickResponse)(request.buildAwsValue())
        .map(zio.aws.wisdom.model.CreateQuickResponseResponse.wrap)
        .provideEnvironment(r)
    def updateKnowledgeBaseTemplateUri(
        request: zio.aws.wisdom.model.UpdateKnowledgeBaseTemplateUriRequest
    ): IO[
      AwsError,
      zio.aws.wisdom.model.UpdateKnowledgeBaseTemplateUriResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateKnowledgeBaseTemplateUriRequest,
      UpdateKnowledgeBaseTemplateUriResponse
    ]("updateKnowledgeBaseTemplateUri", api.updateKnowledgeBaseTemplateUri)(
      request.buildAwsValue()
    ).map(zio.aws.wisdom.model.UpdateKnowledgeBaseTemplateUriResponse.wrap)
      .provideEnvironment(r)
    def getContentSummary(
        request: zio.aws.wisdom.model.GetContentSummaryRequest
    ): IO[AwsError, zio.aws.wisdom.model.GetContentSummaryResponse.ReadOnly] =
      asyncRequestResponse[GetContentSummaryRequest, GetContentSummaryResponse](
        "getContentSummary",
        api.getContentSummary
      )(request.buildAwsValue())
        .map(zio.aws.wisdom.model.GetContentSummaryResponse.wrap)
        .provideEnvironment(r)
    def getKnowledgeBase(
        request: zio.aws.wisdom.model.GetKnowledgeBaseRequest
    ): IO[AwsError, zio.aws.wisdom.model.GetKnowledgeBaseResponse.ReadOnly] =
      asyncRequestResponse[GetKnowledgeBaseRequest, GetKnowledgeBaseResponse](
        "getKnowledgeBase",
        api.getKnowledgeBase
      )(request.buildAwsValue())
        .map(zio.aws.wisdom.model.GetKnowledgeBaseResponse.wrap)
        .provideEnvironment(r)
    def notifyRecommendationsReceived(
        request: zio.aws.wisdom.model.NotifyRecommendationsReceivedRequest
    ): IO[
      AwsError,
      zio.aws.wisdom.model.NotifyRecommendationsReceivedResponse.ReadOnly
    ] = asyncRequestResponse[
      NotifyRecommendationsReceivedRequest,
      NotifyRecommendationsReceivedResponse
    ]("notifyRecommendationsReceived", api.notifyRecommendationsReceived)(
      request.buildAwsValue()
    ).map(zio.aws.wisdom.model.NotifyRecommendationsReceivedResponse.wrap)
      .provideEnvironment(r)
    def searchQuickResponses(
        request: zio.aws.wisdom.model.SearchQuickResponsesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.wisdom.model.QuickResponseSearchResultData.ReadOnly
    ] = asyncJavaPaginatedRequest[
      SearchQuickResponsesRequest,
      QuickResponseSearchResultData,
      SearchQuickResponsesPublisher
    ]("searchQuickResponses", api.searchQuickResponsesPaginator, _.results())(
      request.buildAwsValue()
    ).map(item => zio.aws.wisdom.model.QuickResponseSearchResultData.wrap(item))
      .provideEnvironment(r)
    def searchQuickResponsesPaginated(
        request: zio.aws.wisdom.model.SearchQuickResponsesRequest
    ): IO[
      AwsError,
      zio.aws.wisdom.model.SearchQuickResponsesResponse.ReadOnly
    ] = asyncRequestResponse[
      SearchQuickResponsesRequest,
      SearchQuickResponsesResponse
    ]("searchQuickResponses", api.searchQuickResponses)(request.buildAwsValue())
      .map(zio.aws.wisdom.model.SearchQuickResponsesResponse.wrap)
      .provideEnvironment(r)
    def listAssistantAssociations(
        request: zio.aws.wisdom.model.ListAssistantAssociationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.wisdom.model.AssistantAssociationSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListAssistantAssociationsRequest,
      AssistantAssociationSummary,
      ListAssistantAssociationsPublisher
    ](
      "listAssistantAssociations",
      api.listAssistantAssociationsPaginator,
      _.assistantAssociationSummaries()
    )(request.buildAwsValue())
      .map(item => zio.aws.wisdom.model.AssistantAssociationSummary.wrap(item))
      .provideEnvironment(r)
    def listAssistantAssociationsPaginated(
        request: zio.aws.wisdom.model.ListAssistantAssociationsRequest
    ): IO[
      AwsError,
      zio.aws.wisdom.model.ListAssistantAssociationsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListAssistantAssociationsRequest,
      ListAssistantAssociationsResponse
    ]("listAssistantAssociations", api.listAssistantAssociations)(
      request.buildAwsValue()
    ).map(zio.aws.wisdom.model.ListAssistantAssociationsResponse.wrap)
      .provideEnvironment(r)
    def createContent(
        request: zio.aws.wisdom.model.CreateContentRequest
    ): IO[AwsError, zio.aws.wisdom.model.CreateContentResponse.ReadOnly] =
      asyncRequestResponse[CreateContentRequest, CreateContentResponse](
        "createContent",
        api.createContent
      )(request.buildAwsValue())
        .map(zio.aws.wisdom.model.CreateContentResponse.wrap)
        .provideEnvironment(r)
    def createKnowledgeBase(
        request: zio.aws.wisdom.model.CreateKnowledgeBaseRequest
    ): IO[AwsError, zio.aws.wisdom.model.CreateKnowledgeBaseResponse.ReadOnly] =
      asyncRequestResponse[
        CreateKnowledgeBaseRequest,
        CreateKnowledgeBaseResponse
      ]("createKnowledgeBase", api.createKnowledgeBase)(request.buildAwsValue())
        .map(zio.aws.wisdom.model.CreateKnowledgeBaseResponse.wrap)
        .provideEnvironment(r)
    def listQuickResponses(
        request: zio.aws.wisdom.model.ListQuickResponsesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.wisdom.model.QuickResponseSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListQuickResponsesRequest,
      QuickResponseSummary,
      ListQuickResponsesPublisher
    ](
      "listQuickResponses",
      api.listQuickResponsesPaginator,
      _.quickResponseSummaries()
    )(request.buildAwsValue())
      .map(item => zio.aws.wisdom.model.QuickResponseSummary.wrap(item))
      .provideEnvironment(r)
    def listQuickResponsesPaginated(
        request: zio.aws.wisdom.model.ListQuickResponsesRequest
    ): IO[AwsError, zio.aws.wisdom.model.ListQuickResponsesResponse.ReadOnly] =
      asyncRequestResponse[
        ListQuickResponsesRequest,
        ListQuickResponsesResponse
      ]("listQuickResponses", api.listQuickResponses)(request.buildAwsValue())
        .map(zio.aws.wisdom.model.ListQuickResponsesResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: zio.aws.wisdom.model.UntagResourceRequest
    ): IO[AwsError, zio.aws.wisdom.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue())
        .map(zio.aws.wisdom.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def createAssistant(
        request: zio.aws.wisdom.model.CreateAssistantRequest
    ): IO[AwsError, zio.aws.wisdom.model.CreateAssistantResponse.ReadOnly] =
      asyncRequestResponse[CreateAssistantRequest, CreateAssistantResponse](
        "createAssistant",
        api.createAssistant
      )(request.buildAwsValue())
        .map(zio.aws.wisdom.model.CreateAssistantResponse.wrap)
        .provideEnvironment(r)
    def createAssistantAssociation(
        request: zio.aws.wisdom.model.CreateAssistantAssociationRequest
    ): IO[
      AwsError,
      zio.aws.wisdom.model.CreateAssistantAssociationResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateAssistantAssociationRequest,
      CreateAssistantAssociationResponse
    ]("createAssistantAssociation", api.createAssistantAssociation)(
      request.buildAwsValue()
    ).map(zio.aws.wisdom.model.CreateAssistantAssociationResponse.wrap)
      .provideEnvironment(r)
    def deleteContent(
        request: zio.aws.wisdom.model.DeleteContentRequest
    ): IO[AwsError, zio.aws.wisdom.model.DeleteContentResponse.ReadOnly] =
      asyncRequestResponse[DeleteContentRequest, DeleteContentResponse](
        "deleteContent",
        api.deleteContent
      )(request.buildAwsValue())
        .map(zio.aws.wisdom.model.DeleteContentResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.wisdom.model.ListTagsForResourceRequest
    ): IO[AwsError, zio.aws.wisdom.model.ListTagsForResourceResponse.ReadOnly] =
      asyncRequestResponse[
        ListTagsForResourceRequest,
        ListTagsForResourceResponse
      ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
        .map(zio.aws.wisdom.model.ListTagsForResourceResponse.wrap)
        .provideEnvironment(r)
    def removeKnowledgeBaseTemplateUri(
        request: zio.aws.wisdom.model.RemoveKnowledgeBaseTemplateUriRequest
    ): IO[
      AwsError,
      zio.aws.wisdom.model.RemoveKnowledgeBaseTemplateUriResponse.ReadOnly
    ] = asyncRequestResponse[
      RemoveKnowledgeBaseTemplateUriRequest,
      RemoveKnowledgeBaseTemplateUriResponse
    ]("removeKnowledgeBaseTemplateUri", api.removeKnowledgeBaseTemplateUri)(
      request.buildAwsValue()
    ).map(zio.aws.wisdom.model.RemoveKnowledgeBaseTemplateUriResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: zio.aws.wisdom.model.TagResourceRequest
    ): IO[AwsError, zio.aws.wisdom.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.wisdom.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def getImportJob(
        request: zio.aws.wisdom.model.GetImportJobRequest
    ): IO[AwsError, zio.aws.wisdom.model.GetImportJobResponse.ReadOnly] =
      asyncRequestResponse[GetImportJobRequest, GetImportJobResponse](
        "getImportJob",
        api.getImportJob
      )(request.buildAwsValue())
        .map(zio.aws.wisdom.model.GetImportJobResponse.wrap)
        .provideEnvironment(r)
    def createSession(
        request: zio.aws.wisdom.model.CreateSessionRequest
    ): IO[AwsError, zio.aws.wisdom.model.CreateSessionResponse.ReadOnly] =
      asyncRequestResponse[CreateSessionRequest, CreateSessionResponse](
        "createSession",
        api.createSession
      )(request.buildAwsValue())
        .map(zio.aws.wisdom.model.CreateSessionResponse.wrap)
        .provideEnvironment(r)
    def listContents(
        request: zio.aws.wisdom.model.ListContentsRequest
    ): ZStream[Any, AwsError, zio.aws.wisdom.model.ContentSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListContentsRequest,
        ContentSummary,
        ListContentsPublisher
      ]("listContents", api.listContentsPaginator, _.contentSummaries())(
        request.buildAwsValue()
      ).map(item => zio.aws.wisdom.model.ContentSummary.wrap(item))
        .provideEnvironment(r)
    def listContentsPaginated(
        request: zio.aws.wisdom.model.ListContentsRequest
    ): IO[AwsError, zio.aws.wisdom.model.ListContentsResponse.ReadOnly] =
      asyncRequestResponse[ListContentsRequest, ListContentsResponse](
        "listContents",
        api.listContents
      )(request.buildAwsValue())
        .map(zio.aws.wisdom.model.ListContentsResponse.wrap)
        .provideEnvironment(r)
    def getSession(
        request: zio.aws.wisdom.model.GetSessionRequest
    ): IO[AwsError, zio.aws.wisdom.model.GetSessionResponse.ReadOnly] =
      asyncRequestResponse[GetSessionRequest, GetSessionResponse](
        "getSession",
        api.getSession
      )(request.buildAwsValue())
        .map(zio.aws.wisdom.model.GetSessionResponse.wrap)
        .provideEnvironment(r)
    def deleteImportJob(
        request: zio.aws.wisdom.model.DeleteImportJobRequest
    ): IO[AwsError, zio.aws.wisdom.model.DeleteImportJobResponse.ReadOnly] =
      asyncRequestResponse[DeleteImportJobRequest, DeleteImportJobResponse](
        "deleteImportJob",
        api.deleteImportJob
      )(request.buildAwsValue())
        .map(zio.aws.wisdom.model.DeleteImportJobResponse.wrap)
        .provideEnvironment(r)
    def listAssistants(
        request: zio.aws.wisdom.model.ListAssistantsRequest
    ): ZStream[Any, AwsError, zio.aws.wisdom.model.AssistantSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListAssistantsRequest,
        AssistantSummary,
        ListAssistantsPublisher
      ]("listAssistants", api.listAssistantsPaginator, _.assistantSummaries())(
        request.buildAwsValue()
      ).map(item => zio.aws.wisdom.model.AssistantSummary.wrap(item))
        .provideEnvironment(r)
    def listAssistantsPaginated(
        request: zio.aws.wisdom.model.ListAssistantsRequest
    ): IO[AwsError, zio.aws.wisdom.model.ListAssistantsResponse.ReadOnly] =
      asyncRequestResponse[ListAssistantsRequest, ListAssistantsResponse](
        "listAssistants",
        api.listAssistants
      )(request.buildAwsValue())
        .map(zio.aws.wisdom.model.ListAssistantsResponse.wrap)
        .provideEnvironment(r)
    def listKnowledgeBases(
        request: zio.aws.wisdom.model.ListKnowledgeBasesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.wisdom.model.KnowledgeBaseSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListKnowledgeBasesRequest,
      KnowledgeBaseSummary,
      ListKnowledgeBasesPublisher
    ](
      "listKnowledgeBases",
      api.listKnowledgeBasesPaginator,
      _.knowledgeBaseSummaries()
    )(request.buildAwsValue())
      .map(item => zio.aws.wisdom.model.KnowledgeBaseSummary.wrap(item))
      .provideEnvironment(r)
    def listKnowledgeBasesPaginated(
        request: zio.aws.wisdom.model.ListKnowledgeBasesRequest
    ): IO[AwsError, zio.aws.wisdom.model.ListKnowledgeBasesResponse.ReadOnly] =
      asyncRequestResponse[
        ListKnowledgeBasesRequest,
        ListKnowledgeBasesResponse
      ]("listKnowledgeBases", api.listKnowledgeBases)(request.buildAwsValue())
        .map(zio.aws.wisdom.model.ListKnowledgeBasesResponse.wrap)
        .provideEnvironment(r)
    def deleteAssistant(
        request: zio.aws.wisdom.model.DeleteAssistantRequest
    ): IO[AwsError, zio.aws.wisdom.model.DeleteAssistantResponse.ReadOnly] =
      asyncRequestResponse[DeleteAssistantRequest, DeleteAssistantResponse](
        "deleteAssistant",
        api.deleteAssistant
      )(request.buildAwsValue())
        .map(zio.aws.wisdom.model.DeleteAssistantResponse.wrap)
        .provideEnvironment(r)
    def getQuickResponse(
        request: zio.aws.wisdom.model.GetQuickResponseRequest
    ): IO[AwsError, zio.aws.wisdom.model.GetQuickResponseResponse.ReadOnly] =
      asyncRequestResponse[GetQuickResponseRequest, GetQuickResponseResponse](
        "getQuickResponse",
        api.getQuickResponse
      )(request.buildAwsValue())
        .map(zio.aws.wisdom.model.GetQuickResponseResponse.wrap)
        .provideEnvironment(r)
  }
  def getAssistant(request: zio.aws.wisdom.model.GetAssistantRequest): ZIO[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.GetAssistantResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAssistant(request))
  def updateQuickResponse(
      request: zio.aws.wisdom.model.UpdateQuickResponseRequest
  ): ZIO[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.UpdateQuickResponseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateQuickResponse(request))
  def startContentUpload(
      request: zio.aws.wisdom.model.StartContentUploadRequest
  ): ZIO[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.StartContentUploadResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startContentUpload(request))
  def deleteQuickResponse(
      request: zio.aws.wisdom.model.DeleteQuickResponseRequest
  ): ZIO[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.DeleteQuickResponseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteQuickResponse(request))
  def deleteKnowledgeBase(
      request: zio.aws.wisdom.model.DeleteKnowledgeBaseRequest
  ): ZIO[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.DeleteKnowledgeBaseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteKnowledgeBase(request))
  def listImportJobs(
      request: zio.aws.wisdom.model.ListImportJobsRequest
  ): ZStream[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.ImportJobSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listImportJobs(request))
  def listImportJobsPaginated(
      request: zio.aws.wisdom.model.ListImportJobsRequest
  ): ZIO[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.ListImportJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listImportJobsPaginated(request))
  def searchSessions(
      request: zio.aws.wisdom.model.SearchSessionsRequest
  ): ZStream[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.SessionSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.searchSessions(request))
  def searchSessionsPaginated(
      request: zio.aws.wisdom.model.SearchSessionsRequest
  ): ZIO[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.SearchSessionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchSessionsPaginated(request))
  def getAssistantAssociation(
      request: zio.aws.wisdom.model.GetAssistantAssociationRequest
  ): ZIO[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.GetAssistantAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAssistantAssociation(request))
  def getContent(request: zio.aws.wisdom.model.GetContentRequest): ZIO[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.GetContentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getContent(request))
  def searchContent(
      request: zio.aws.wisdom.model.SearchContentRequest
  ): ZStream[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.ContentSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.searchContent(request))
  def searchContentPaginated(
      request: zio.aws.wisdom.model.SearchContentRequest
  ): ZIO[zio.aws.wisdom.Wisdom, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.searchContentPaginated(request))
  def deleteAssistantAssociation(
      request: zio.aws.wisdom.model.DeleteAssistantAssociationRequest
  ): ZIO[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.DeleteAssistantAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAssistantAssociation(request))
  def updateContent(request: zio.aws.wisdom.model.UpdateContentRequest): ZIO[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.UpdateContentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateContent(request))
  def startImportJob(request: zio.aws.wisdom.model.StartImportJobRequest): ZIO[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.StartImportJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startImportJob(request))
  def createQuickResponse(
      request: zio.aws.wisdom.model.CreateQuickResponseRequest
  ): ZIO[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.CreateQuickResponseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createQuickResponse(request))
  def updateKnowledgeBaseTemplateUri(
      request: zio.aws.wisdom.model.UpdateKnowledgeBaseTemplateUriRequest
  ): ZIO[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.UpdateKnowledgeBaseTemplateUriResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateKnowledgeBaseTemplateUri(request))
  def getContentSummary(
      request: zio.aws.wisdom.model.GetContentSummaryRequest
  ): ZIO[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.GetContentSummaryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getContentSummary(request))
  def getKnowledgeBase(
      request: zio.aws.wisdom.model.GetKnowledgeBaseRequest
  ): ZIO[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.GetKnowledgeBaseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getKnowledgeBase(request))
  def notifyRecommendationsReceived(
      request: zio.aws.wisdom.model.NotifyRecommendationsReceivedRequest
  ): ZIO[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.NotifyRecommendationsReceivedResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.notifyRecommendationsReceived(request))
  def searchQuickResponses(
      request: zio.aws.wisdom.model.SearchQuickResponsesRequest
  ): ZStream[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.QuickResponseSearchResultData.ReadOnly
  ] = ZStream.serviceWithStream(_.searchQuickResponses(request))
  def searchQuickResponsesPaginated(
      request: zio.aws.wisdom.model.SearchQuickResponsesRequest
  ): ZIO[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.SearchQuickResponsesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchQuickResponsesPaginated(request))
  def listAssistantAssociations(
      request: zio.aws.wisdom.model.ListAssistantAssociationsRequest
  ): ZStream[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.AssistantAssociationSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listAssistantAssociations(request))
  def listAssistantAssociationsPaginated(
      request: zio.aws.wisdom.model.ListAssistantAssociationsRequest
  ): ZIO[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.ListAssistantAssociationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAssistantAssociationsPaginated(request))
  def createContent(request: zio.aws.wisdom.model.CreateContentRequest): ZIO[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.CreateContentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createContent(request))
  def createKnowledgeBase(
      request: zio.aws.wisdom.model.CreateKnowledgeBaseRequest
  ): ZIO[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.CreateKnowledgeBaseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createKnowledgeBase(request))
  def listQuickResponses(
      request: zio.aws.wisdom.model.ListQuickResponsesRequest
  ): ZStream[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.QuickResponseSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listQuickResponses(request))
  def listQuickResponsesPaginated(
      request: zio.aws.wisdom.model.ListQuickResponsesRequest
  ): ZIO[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.ListQuickResponsesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listQuickResponsesPaginated(request))
  def untagResource(request: zio.aws.wisdom.model.UntagResourceRequest): ZIO[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def createAssistant(
      request: zio.aws.wisdom.model.CreateAssistantRequest
  ): ZIO[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.CreateAssistantResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAssistant(request))
  def createAssistantAssociation(
      request: zio.aws.wisdom.model.CreateAssistantAssociationRequest
  ): ZIO[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.CreateAssistantAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAssistantAssociation(request))
  def deleteContent(request: zio.aws.wisdom.model.DeleteContentRequest): ZIO[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.DeleteContentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteContent(request))
  def listTagsForResource(
      request: zio.aws.wisdom.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def removeKnowledgeBaseTemplateUri(
      request: zio.aws.wisdom.model.RemoveKnowledgeBaseTemplateUriRequest
  ): ZIO[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.RemoveKnowledgeBaseTemplateUriResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.removeKnowledgeBaseTemplateUri(request))
  def tagResource(request: zio.aws.wisdom.model.TagResourceRequest): ZIO[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def getImportJob(request: zio.aws.wisdom.model.GetImportJobRequest): ZIO[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.GetImportJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getImportJob(request))
  def createSession(request: zio.aws.wisdom.model.CreateSessionRequest): ZIO[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.CreateSessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSession(request))
  def listContents(request: zio.aws.wisdom.model.ListContentsRequest): ZStream[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.ContentSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listContents(request))
  def listContentsPaginated(
      request: zio.aws.wisdom.model.ListContentsRequest
  ): ZIO[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.ListContentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listContentsPaginated(request))
  def getSession(request: zio.aws.wisdom.model.GetSessionRequest): ZIO[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.GetSessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSession(request))
  def deleteImportJob(
      request: zio.aws.wisdom.model.DeleteImportJobRequest
  ): ZIO[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.DeleteImportJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteImportJob(request))
  def listAssistants(
      request: zio.aws.wisdom.model.ListAssistantsRequest
  ): ZStream[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.AssistantSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listAssistants(request))
  def listAssistantsPaginated(
      request: zio.aws.wisdom.model.ListAssistantsRequest
  ): ZIO[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.ListAssistantsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAssistantsPaginated(request))
  def listKnowledgeBases(
      request: zio.aws.wisdom.model.ListKnowledgeBasesRequest
  ): ZStream[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.KnowledgeBaseSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listKnowledgeBases(request))
  def listKnowledgeBasesPaginated(
      request: zio.aws.wisdom.model.ListKnowledgeBasesRequest
  ): ZIO[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.ListKnowledgeBasesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listKnowledgeBasesPaginated(request))
  def deleteAssistant(
      request: zio.aws.wisdom.model.DeleteAssistantRequest
  ): ZIO[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.DeleteAssistantResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAssistant(request))
  def getQuickResponse(
      request: zio.aws.wisdom.model.GetQuickResponseRequest
  ): ZIO[
    zio.aws.wisdom.Wisdom,
    AwsError,
    zio.aws.wisdom.model.GetQuickResponseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getQuickResponse(request))
}
