package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wisdom.model.primitives.{NonEmptyString, GenericArn}
import scala.jdk.CollectionConverters.*
final case class AppIntegrationsConfiguration(
    appIntegrationArn: GenericArn,
    objectFields: Optional[Iterable[NonEmptyString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.AppIntegrationsConfiguration = {
    import AppIntegrationsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.AppIntegrationsConfiguration
      .builder()
      .appIntegrationArn(GenericArn.unwrap(appIntegrationArn): java.lang.String)
      .optionallyWith(
        objectFields.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.objectFields)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.AppIntegrationsConfiguration.ReadOnly =
    zio.aws.wisdom.model.AppIntegrationsConfiguration.wrap(buildAwsValue())
}
object AppIntegrationsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.AppIntegrationsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.AppIntegrationsConfiguration =
      zio.aws.wisdom.model.AppIntegrationsConfiguration(
        appIntegrationArn,
        objectFields.map(value => value)
      )
    def appIntegrationArn: GenericArn
    def objectFields: Optional[List[NonEmptyString]]
    def getAppIntegrationArn: ZIO[Any, Nothing, GenericArn] =
      ZIO.succeed(appIntegrationArn)
    def getObjectFields: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("objectFields", objectFields)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.AppIntegrationsConfiguration
  ) extends zio.aws.wisdom.model.AppIntegrationsConfiguration.ReadOnly {
    override val appIntegrationArn: GenericArn =
      zio.aws.wisdom.model.primitives.GenericArn(impl.appIntegrationArn())
    override val objectFields: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectFields())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wisdom.model.primitives.NonEmptyString(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.AppIntegrationsConfiguration
  ): zio.aws.wisdom.model.AppIntegrationsConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
