package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wisdom.model.primitives.{
  TagValue,
  Arn,
  Uuid,
  Description,
  Name,
  TagKey
}
import scala.jdk.CollectionConverters.*
final case class AssistantData(
    assistantArn: Arn,
    assistantId: Uuid,
    description: Optional[Description] = Optional.Absent,
    integrationConfiguration: Optional[
      zio.aws.wisdom.model.AssistantIntegrationConfiguration
    ] = Optional.Absent,
    name: Name,
    serverSideEncryptionConfiguration: Optional[
      zio.aws.wisdom.model.ServerSideEncryptionConfiguration
    ] = Optional.Absent,
    status: zio.aws.wisdom.model.AssistantStatus,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    `type`: zio.aws.wisdom.model.AssistantType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.AssistantData = {
    import AssistantData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.AssistantData
      .builder()
      .assistantArn(Arn.unwrap(assistantArn): java.lang.String)
      .assistantId(Uuid.unwrap(assistantId): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        integrationConfiguration.map(value => value.buildAwsValue())
      )(_.integrationConfiguration)
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        serverSideEncryptionConfiguration.map(value => value.buildAwsValue())
      )(_.serverSideEncryptionConfiguration)
      .status(status.unwrap)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.AssistantData.ReadOnly =
    zio.aws.wisdom.model.AssistantData.wrap(buildAwsValue())
}
object AssistantData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.AssistantData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.AssistantData =
      zio.aws.wisdom.model.AssistantData(
        assistantArn,
        assistantId,
        description.map(value => value),
        integrationConfiguration.map(value => value.asEditable),
        name,
        serverSideEncryptionConfiguration.map(value => value.asEditable),
        status,
        tags.map(value => value),
        `type`
      )
    def assistantArn: Arn
    def assistantId: Uuid
    def description: Optional[Description]
    def integrationConfiguration: Optional[
      zio.aws.wisdom.model.AssistantIntegrationConfiguration.ReadOnly
    ]
    def name: Name
    def serverSideEncryptionConfiguration: Optional[
      zio.aws.wisdom.model.ServerSideEncryptionConfiguration.ReadOnly
    ]
    def status: zio.aws.wisdom.model.AssistantStatus
    def tags: Optional[Map[TagKey, TagValue]]
    def `type`: zio.aws.wisdom.model.AssistantType
    def getAssistantArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(assistantArn)
    def getAssistantId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(assistantId)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getIntegrationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.wisdom.model.AssistantIntegrationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "integrationConfiguration",
      integrationConfiguration
    )
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getServerSideEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.wisdom.model.ServerSideEncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serverSideEncryptionConfiguration",
      serverSideEncryptionConfiguration
    )
    def getStatus: ZIO[Any, Nothing, zio.aws.wisdom.model.AssistantStatus] =
      ZIO.succeed(status)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getType: ZIO[Any, Nothing, zio.aws.wisdom.model.AssistantType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.AssistantData
  ) extends zio.aws.wisdom.model.AssistantData.ReadOnly {
    override val assistantArn: Arn =
      zio.aws.wisdom.model.primitives.Arn(impl.assistantArn())
    override val assistantId: Uuid =
      zio.aws.wisdom.model.primitives.Uuid(impl.assistantId())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.wisdom.model.primitives.Description(value))
    override val integrationConfiguration: Optional[
      zio.aws.wisdom.model.AssistantIntegrationConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.integrationConfiguration())
      .map(value =>
        zio.aws.wisdom.model.AssistantIntegrationConfiguration.wrap(value)
      )
    override val name: Name = zio.aws.wisdom.model.primitives.Name(impl.name())
    override val serverSideEncryptionConfiguration: Optional[
      zio.aws.wisdom.model.ServerSideEncryptionConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serverSideEncryptionConfiguration())
      .map(value =>
        zio.aws.wisdom.model.ServerSideEncryptionConfiguration.wrap(value)
      )
    override val status: zio.aws.wisdom.model.AssistantStatus =
      zio.aws.wisdom.model.AssistantStatus.wrap(impl.status())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.wisdom.model.primitives
              .TagKey(key) -> zio.aws.wisdom.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val `type`: zio.aws.wisdom.model.AssistantType =
      zio.aws.wisdom.model.AssistantType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.AssistantData
  ): zio.aws.wisdom.model.AssistantData.ReadOnly = new Wrapper(impl)
}
