package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wisdom.model.primitives.GenericArn
import scala.jdk.CollectionConverters.*
final case class AssistantIntegrationConfiguration(
    topicIntegrationArn: Optional[GenericArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.AssistantIntegrationConfiguration = {
    import AssistantIntegrationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.AssistantIntegrationConfiguration
      .builder()
      .optionallyWith(
        topicIntegrationArn.map(value =>
          GenericArn.unwrap(value): java.lang.String
        )
      )(_.topicIntegrationArn)
      .build()
  }
  def asReadOnly
      : zio.aws.wisdom.model.AssistantIntegrationConfiguration.ReadOnly =
    zio.aws.wisdom.model.AssistantIntegrationConfiguration.wrap(buildAwsValue())
}
object AssistantIntegrationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.AssistantIntegrationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.AssistantIntegrationConfiguration =
      zio.aws.wisdom.model.AssistantIntegrationConfiguration(
        topicIntegrationArn.map(value => value)
      )
    def topicIntegrationArn: Optional[GenericArn]
    def getTopicIntegrationArn: ZIO[Any, AwsError, GenericArn] =
      AwsError.unwrapOptionField("topicIntegrationArn", topicIntegrationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.AssistantIntegrationConfiguration
  ) extends zio.aws.wisdom.model.AssistantIntegrationConfiguration.ReadOnly {
    override val topicIntegrationArn: Optional[GenericArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.topicIntegrationArn())
        .map(value => zio.aws.wisdom.model.primitives.GenericArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.AssistantIntegrationConfiguration
  ): zio.aws.wisdom.model.AssistantIntegrationConfiguration.ReadOnly =
    new Wrapper(impl)
}
