package zio.aws.wisdom.model
import scala.jdk.CollectionConverters.*
sealed trait AssociationType {
  def unwrap: software.amazon.awssdk.services.wisdom.model.AssociationType
}
object AssociationType {
  def wrap(
      value: software.amazon.awssdk.services.wisdom.model.AssociationType
  ): zio.aws.wisdom.model.AssociationType = value match {
    case software.amazon.awssdk.services.wisdom.model.AssociationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.wisdom.model.AssociationType.KNOWLEDGE_BASE =>
      val r = KNOWLEDGE_BASE
      r
  }
  case object unknownToSdkVersion extends zio.aws.wisdom.model.AssociationType {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.AssociationType =
      software.amazon.awssdk.services.wisdom.model.AssociationType.UNKNOWN_TO_SDK_VERSION
  }
  case object KNOWLEDGE_BASE extends zio.aws.wisdom.model.AssociationType {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.AssociationType =
      software.amazon.awssdk.services.wisdom.model.AssociationType.KNOWLEDGE_BASE
  }
}
