package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Configuration(
    connectConfiguration: Optional[zio.aws.wisdom.model.ConnectConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.Configuration = {
    import Configuration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.Configuration
      .builder()
      .optionallyWith(connectConfiguration.map(value => value.buildAwsValue()))(
        _.connectConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.Configuration.ReadOnly =
    zio.aws.wisdom.model.Configuration.wrap(buildAwsValue())
}
object Configuration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.Configuration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.Configuration = zio.aws.wisdom.model
      .Configuration(connectConfiguration.map(value => value.asEditable))
    def connectConfiguration
        : Optional[zio.aws.wisdom.model.ConnectConfiguration.ReadOnly]
    def getConnectConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.wisdom.model.ConnectConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("connectConfiguration", connectConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.Configuration
  ) extends zio.aws.wisdom.model.Configuration.ReadOnly {
    override val connectConfiguration
        : Optional[zio.aws.wisdom.model.ConnectConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectConfiguration())
        .map(value => zio.aws.wisdom.model.ConnectConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.Configuration
  ): zio.aws.wisdom.model.Configuration.ReadOnly = new Wrapper(impl)
}
