package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wisdom.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters.*
final case class ConnectConfiguration(
    instanceId: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.ConnectConfiguration = {
    import ConnectConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.ConnectConfiguration
      .builder()
      .optionallyWith(
        instanceId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.instanceId)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.ConnectConfiguration.ReadOnly =
    zio.aws.wisdom.model.ConnectConfiguration.wrap(buildAwsValue())
}
object ConnectConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.ConnectConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.ConnectConfiguration =
      zio.aws.wisdom.model.ConnectConfiguration(instanceId.map(value => value))
    def instanceId: Optional[NonEmptyString]
    def getInstanceId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("instanceId", instanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.ConnectConfiguration
  ) extends zio.aws.wisdom.model.ConnectConfiguration.ReadOnly {
    override val instanceId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => zio.aws.wisdom.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.ConnectConfiguration
  ): zio.aws.wisdom.model.ConnectConfiguration.ReadOnly = new Wrapper(impl)
}
