package zio.aws.wisdom.model
import zio.aws.wisdom.model.primitives.{
  SyntheticTimestamp_epoch_seconds,
  ContentType,
  ContentTitle,
  Url,
  TagValue,
  Uri,
  Arn,
  Uuid,
  Name,
  NonEmptyString,
  TagKey
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ContentData(
    contentArn: Arn,
    contentId: Uuid,
    contentType: ContentType,
    knowledgeBaseArn: Arn,
    knowledgeBaseId: Uuid,
    linkOutUri: Optional[Uri] = Optional.Absent,
    metadata: Map[NonEmptyString, NonEmptyString],
    name: Name,
    revisionId: NonEmptyString,
    status: zio.aws.wisdom.model.ContentStatus,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    title: ContentTitle,
    url: Url,
    urlExpiry: SyntheticTimestamp_epoch_seconds
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.ContentData = {
    import ContentData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.ContentData
      .builder()
      .contentArn(Arn.unwrap(contentArn): java.lang.String)
      .contentId(Uuid.unwrap(contentId): java.lang.String)
      .contentType(ContentType.unwrap(contentType): java.lang.String)
      .knowledgeBaseArn(Arn.unwrap(knowledgeBaseArn): java.lang.String)
      .knowledgeBaseId(Uuid.unwrap(knowledgeBaseId): java.lang.String)
      .optionallyWith(
        linkOutUri.map(value => Uri.unwrap(value): java.lang.String)
      )(_.linkOutUri)
      .metadata(
        metadata
          .map({ case (key, value) =>
            (NonEmptyString.unwrap(key): java.lang.String) -> (NonEmptyString
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .name(Name.unwrap(name): java.lang.String)
      .revisionId(NonEmptyString.unwrap(revisionId): java.lang.String)
      .status(status.unwrap)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .title(ContentTitle.unwrap(title): java.lang.String)
      .url(Url.unwrap(url): java.lang.String)
      .urlExpiry(SyntheticTimestamp_epoch_seconds.unwrap(urlExpiry): Instant)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.ContentData.ReadOnly =
    zio.aws.wisdom.model.ContentData.wrap(buildAwsValue())
}
object ContentData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.ContentData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.ContentData =
      zio.aws.wisdom.model.ContentData(
        contentArn,
        contentId,
        contentType,
        knowledgeBaseArn,
        knowledgeBaseId,
        linkOutUri.map(value => value),
        metadata,
        name,
        revisionId,
        status,
        tags.map(value => value),
        title,
        url,
        urlExpiry
      )
    def contentArn: Arn
    def contentId: Uuid
    def contentType: ContentType
    def knowledgeBaseArn: Arn
    def knowledgeBaseId: Uuid
    def linkOutUri: Optional[Uri]
    def metadata: Map[NonEmptyString, NonEmptyString]
    def name: Name
    def revisionId: NonEmptyString
    def status: zio.aws.wisdom.model.ContentStatus
    def tags: Optional[Map[TagKey, TagValue]]
    def title: ContentTitle
    def url: Url
    def urlExpiry: SyntheticTimestamp_epoch_seconds
    def getContentArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(contentArn)
    def getContentId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(contentId)
    def getContentType: ZIO[Any, Nothing, ContentType] =
      ZIO.succeed(contentType)
    def getKnowledgeBaseArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(knowledgeBaseArn)
    def getKnowledgeBaseId: ZIO[Any, Nothing, Uuid] =
      ZIO.succeed(knowledgeBaseId)
    def getLinkOutUri: ZIO[Any, AwsError, Uri] =
      AwsError.unwrapOptionField("linkOutUri", linkOutUri)
    def getMetadata: ZIO[Any, Nothing, Map[NonEmptyString, NonEmptyString]] =
      ZIO.succeed(metadata)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getRevisionId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(revisionId)
    def getStatus: ZIO[Any, Nothing, zio.aws.wisdom.model.ContentStatus] =
      ZIO.succeed(status)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTitle: ZIO[Any, Nothing, ContentTitle] = ZIO.succeed(title)
    def getUrl: ZIO[Any, Nothing, Url] = ZIO.succeed(url)
    def getUrlExpiry: ZIO[Any, Nothing, SyntheticTimestamp_epoch_seconds] =
      ZIO.succeed(urlExpiry)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.ContentData
  ) extends zio.aws.wisdom.model.ContentData.ReadOnly {
    override val contentArn: Arn =
      zio.aws.wisdom.model.primitives.Arn(impl.contentArn())
    override val contentId: Uuid =
      zio.aws.wisdom.model.primitives.Uuid(impl.contentId())
    override val contentType: ContentType =
      zio.aws.wisdom.model.primitives.ContentType(impl.contentType())
    override val knowledgeBaseArn: Arn =
      zio.aws.wisdom.model.primitives.Arn(impl.knowledgeBaseArn())
    override val knowledgeBaseId: Uuid =
      zio.aws.wisdom.model.primitives.Uuid(impl.knowledgeBaseId())
    override val linkOutUri: Optional[Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.linkOutUri())
      .map(value => zio.aws.wisdom.model.primitives.Uri(value))
    override val metadata: Map[NonEmptyString, NonEmptyString] = impl
      .metadata()
      .asScala
      .map({ case (key, value) =>
        zio.aws.wisdom.model.primitives.NonEmptyString(
          key
        ) -> zio.aws.wisdom.model.primitives.NonEmptyString(value)
      })
      .toMap
    override val name: Name = zio.aws.wisdom.model.primitives.Name(impl.name())
    override val revisionId: NonEmptyString =
      zio.aws.wisdom.model.primitives.NonEmptyString(impl.revisionId())
    override val status: zio.aws.wisdom.model.ContentStatus =
      zio.aws.wisdom.model.ContentStatus.wrap(impl.status())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.wisdom.model.primitives
              .TagKey(key) -> zio.aws.wisdom.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val title: ContentTitle =
      zio.aws.wisdom.model.primitives.ContentTitle(impl.title())
    override val url: Url = zio.aws.wisdom.model.primitives.Url(impl.url())
    override val urlExpiry: SyntheticTimestamp_epoch_seconds =
      zio.aws.wisdom.model.primitives
        .SyntheticTimestamp_epoch_seconds(impl.urlExpiry())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.ContentData
  ): zio.aws.wisdom.model.ContentData.ReadOnly = new Wrapper(impl)
}
