package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wisdom.model.primitives.{
  TagValue,
  TagKey,
  ClientToken,
  UuidOrArn
}
import scala.jdk.CollectionConverters.*
final case class CreateAssistantAssociationRequest(
    assistantId: UuidOrArn,
    association: zio.aws.wisdom.model.AssistantAssociationInputData,
    associationType: zio.aws.wisdom.model.AssociationType,
    clientToken: Optional[ClientToken] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.CreateAssistantAssociationRequest = {
    import CreateAssistantAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.CreateAssistantAssociationRequest
      .builder()
      .assistantId(UuidOrArn.unwrap(assistantId): java.lang.String)
      .association(association.buildAwsValue())
      .associationType(associationType.unwrap)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.wisdom.model.CreateAssistantAssociationRequest.ReadOnly =
    zio.aws.wisdom.model.CreateAssistantAssociationRequest.wrap(buildAwsValue())
}
object CreateAssistantAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.CreateAssistantAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.CreateAssistantAssociationRequest =
      zio.aws.wisdom.model.CreateAssistantAssociationRequest(
        assistantId,
        association.asEditable,
        associationType,
        clientToken.map(value => value),
        tags.map(value => value)
      )
    def assistantId: UuidOrArn
    def association: zio.aws.wisdom.model.AssistantAssociationInputData.ReadOnly
    def associationType: zio.aws.wisdom.model.AssociationType
    def clientToken: Optional[ClientToken]
    def tags: Optional[Map[TagKey, TagValue]]
    def getAssistantId: ZIO[Any, Nothing, UuidOrArn] = ZIO.succeed(assistantId)
    def getAssociation: ZIO[
      Any,
      Nothing,
      zio.aws.wisdom.model.AssistantAssociationInputData.ReadOnly
    ] = ZIO.succeed(association)
    def getAssociationType
        : ZIO[Any, Nothing, zio.aws.wisdom.model.AssociationType] =
      ZIO.succeed(associationType)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.CreateAssistantAssociationRequest
  ) extends zio.aws.wisdom.model.CreateAssistantAssociationRequest.ReadOnly {
    override val assistantId: UuidOrArn =
      zio.aws.wisdom.model.primitives.UuidOrArn(impl.assistantId())
    override val association
        : zio.aws.wisdom.model.AssistantAssociationInputData.ReadOnly =
      zio.aws.wisdom.model.AssistantAssociationInputData
        .wrap(impl.association())
    override val associationType: zio.aws.wisdom.model.AssociationType =
      zio.aws.wisdom.model.AssociationType.wrap(impl.associationType())
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.wisdom.model.primitives.ClientToken(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.wisdom.model.primitives
              .TagKey(key) -> zio.aws.wisdom.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.CreateAssistantAssociationRequest
  ): zio.aws.wisdom.model.CreateAssistantAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
