package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wisdom.model.primitives.{
  QuickResponseName,
  LanguageCode,
  TagValue,
  QuickResponseType,
  ShortCutKey,
  Channel,
  QuickResponseDescription,
  UuidOrArn,
  NonEmptyString,
  TagKey
}
import scala.jdk.CollectionConverters.*
final case class CreateQuickResponseRequest(
    channels: Optional[Iterable[Channel]] = Optional.Absent,
    clientToken: Optional[NonEmptyString] = Optional.Absent,
    content: zio.aws.wisdom.model.QuickResponseDataProvider,
    contentType: Optional[QuickResponseType] = Optional.Absent,
    description: Optional[QuickResponseDescription] = Optional.Absent,
    groupingConfiguration: Optional[
      zio.aws.wisdom.model.GroupingConfiguration
    ] = Optional.Absent,
    isActive: Optional[Boolean] = Optional.Absent,
    knowledgeBaseId: UuidOrArn,
    language: Optional[LanguageCode] = Optional.Absent,
    name: QuickResponseName,
    shortcutKey: Optional[ShortCutKey] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.CreateQuickResponseRequest = {
    import CreateQuickResponseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.CreateQuickResponseRequest
      .builder()
      .optionallyWith(
        channels.map(value =>
          value.map { item =>
            Channel.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.channels)
      .optionallyWith(
        clientToken.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.clientToken)
      .content(content.buildAwsValue())
      .optionallyWith(
        contentType.map(value =>
          QuickResponseType.unwrap(value): java.lang.String
        )
      )(_.contentType)
      .optionallyWith(
        description.map(value =>
          QuickResponseDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        groupingConfiguration.map(value => value.buildAwsValue())
      )(_.groupingConfiguration)
      .optionallyWith(isActive.map(value => value: java.lang.Boolean))(
        _.isActive
      )
      .knowledgeBaseId(UuidOrArn.unwrap(knowledgeBaseId): java.lang.String)
      .optionallyWith(
        language.map(value => LanguageCode.unwrap(value): java.lang.String)
      )(_.language)
      .name(QuickResponseName.unwrap(name): java.lang.String)
      .optionallyWith(
        shortcutKey.map(value => ShortCutKey.unwrap(value): java.lang.String)
      )(_.shortcutKey)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.CreateQuickResponseRequest.ReadOnly =
    zio.aws.wisdom.model.CreateQuickResponseRequest.wrap(buildAwsValue())
}
object CreateQuickResponseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.CreateQuickResponseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.CreateQuickResponseRequest =
      zio.aws.wisdom.model.CreateQuickResponseRequest(
        channels.map(value => value),
        clientToken.map(value => value),
        content.asEditable,
        contentType.map(value => value),
        description.map(value => value),
        groupingConfiguration.map(value => value.asEditable),
        isActive.map(value => value),
        knowledgeBaseId,
        language.map(value => value),
        name,
        shortcutKey.map(value => value),
        tags.map(value => value)
      )
    def channels: Optional[List[Channel]]
    def clientToken: Optional[NonEmptyString]
    def content: zio.aws.wisdom.model.QuickResponseDataProvider.ReadOnly
    def contentType: Optional[QuickResponseType]
    def description: Optional[QuickResponseDescription]
    def groupingConfiguration
        : Optional[zio.aws.wisdom.model.GroupingConfiguration.ReadOnly]
    def isActive: Optional[Boolean]
    def knowledgeBaseId: UuidOrArn
    def language: Optional[LanguageCode]
    def name: QuickResponseName
    def shortcutKey: Optional[ShortCutKey]
    def tags: Optional[Map[TagKey, TagValue]]
    def getChannels: ZIO[Any, AwsError, List[Channel]] =
      AwsError.unwrapOptionField("channels", channels)
    def getClientToken: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getContent: ZIO[
      Any,
      Nothing,
      zio.aws.wisdom.model.QuickResponseDataProvider.ReadOnly
    ] = ZIO.succeed(content)
    def getContentType: ZIO[Any, AwsError, QuickResponseType] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getDescription: ZIO[Any, AwsError, QuickResponseDescription] =
      AwsError.unwrapOptionField("description", description)
    def getGroupingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.wisdom.model.GroupingConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("groupingConfiguration", groupingConfiguration)
    def getIsActive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isActive", isActive)
    def getKnowledgeBaseId: ZIO[Any, Nothing, UuidOrArn] =
      ZIO.succeed(knowledgeBaseId)
    def getLanguage: ZIO[Any, AwsError, LanguageCode] =
      AwsError.unwrapOptionField("language", language)
    def getName: ZIO[Any, Nothing, QuickResponseName] = ZIO.succeed(name)
    def getShortcutKey: ZIO[Any, AwsError, ShortCutKey] =
      AwsError.unwrapOptionField("shortcutKey", shortcutKey)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.CreateQuickResponseRequest
  ) extends zio.aws.wisdom.model.CreateQuickResponseRequest.ReadOnly {
    override val channels: Optional[List[Channel]] = zio.aws.core.internal
      .optionalFromNullable(impl.channels())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wisdom.model.primitives.Channel(item)
        }.toList
      )
    override val clientToken: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.wisdom.model.primitives.NonEmptyString(value))
    override val content
        : zio.aws.wisdom.model.QuickResponseDataProvider.ReadOnly =
      zio.aws.wisdom.model.QuickResponseDataProvider.wrap(impl.content())
    override val contentType: Optional[QuickResponseType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentType())
        .map(value => zio.aws.wisdom.model.primitives.QuickResponseType(value))
    override val description: Optional[QuickResponseDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.wisdom.model.primitives.QuickResponseDescription(value)
        )
    override val groupingConfiguration
        : Optional[zio.aws.wisdom.model.GroupingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groupingConfiguration())
        .map(value => zio.aws.wisdom.model.GroupingConfiguration.wrap(value))
    override val isActive: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isActive())
      .map(value => value: Boolean)
    override val knowledgeBaseId: UuidOrArn =
      zio.aws.wisdom.model.primitives.UuidOrArn(impl.knowledgeBaseId())
    override val language: Optional[LanguageCode] = zio.aws.core.internal
      .optionalFromNullable(impl.language())
      .map(value => zio.aws.wisdom.model.primitives.LanguageCode(value))
    override val name: QuickResponseName =
      zio.aws.wisdom.model.primitives.QuickResponseName(impl.name())
    override val shortcutKey: Optional[ShortCutKey] = zio.aws.core.internal
      .optionalFromNullable(impl.shortcutKey())
      .map(value => zio.aws.wisdom.model.primitives.ShortCutKey(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.wisdom.model.primitives
              .TagKey(key) -> zio.aws.wisdom.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.CreateQuickResponseRequest
  ): zio.aws.wisdom.model.CreateQuickResponseRequest.ReadOnly = new Wrapper(
    impl
  )
}
