package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateQuickResponseResponse(
    quickResponse: Optional[zio.aws.wisdom.model.QuickResponseData] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.CreateQuickResponseResponse = {
    import CreateQuickResponseResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.CreateQuickResponseResponse
      .builder()
      .optionallyWith(quickResponse.map(value => value.buildAwsValue()))(
        _.quickResponse
      )
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.CreateQuickResponseResponse.ReadOnly =
    zio.aws.wisdom.model.CreateQuickResponseResponse.wrap(buildAwsValue())
}
object CreateQuickResponseResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.CreateQuickResponseResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.CreateQuickResponseResponse =
      zio.aws.wisdom.model.CreateQuickResponseResponse(
        quickResponse.map(value => value.asEditable)
      )
    def quickResponse: Optional[zio.aws.wisdom.model.QuickResponseData.ReadOnly]
    def getQuickResponse
        : ZIO[Any, AwsError, zio.aws.wisdom.model.QuickResponseData.ReadOnly] =
      AwsError.unwrapOptionField("quickResponse", quickResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.CreateQuickResponseResponse
  ) extends zio.aws.wisdom.model.CreateQuickResponseResponse.ReadOnly {
    override val quickResponse
        : Optional[zio.aws.wisdom.model.QuickResponseData.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.quickResponse())
        .map(value => zio.aws.wisdom.model.QuickResponseData.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.CreateQuickResponseResponse
  ): zio.aws.wisdom.model.CreateQuickResponseResponse.ReadOnly = new Wrapper(
    impl
  )
}
