package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wisdom.model.primitives.UuidOrArn
import scala.jdk.CollectionConverters.*
final case class DeleteAssistantAssociationRequest(
    assistantAssociationId: UuidOrArn,
    assistantId: UuidOrArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.DeleteAssistantAssociationRequest = {
    import DeleteAssistantAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.DeleteAssistantAssociationRequest
      .builder()
      .assistantAssociationId(
        UuidOrArn.unwrap(assistantAssociationId): java.lang.String
      )
      .assistantId(UuidOrArn.unwrap(assistantId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.wisdom.model.DeleteAssistantAssociationRequest.ReadOnly =
    zio.aws.wisdom.model.DeleteAssistantAssociationRequest.wrap(buildAwsValue())
}
object DeleteAssistantAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.DeleteAssistantAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.DeleteAssistantAssociationRequest =
      zio.aws.wisdom.model
        .DeleteAssistantAssociationRequest(assistantAssociationId, assistantId)
    def assistantAssociationId: UuidOrArn
    def assistantId: UuidOrArn
    def getAssistantAssociationId: ZIO[Any, Nothing, UuidOrArn] =
      ZIO.succeed(assistantAssociationId)
    def getAssistantId: ZIO[Any, Nothing, UuidOrArn] = ZIO.succeed(assistantId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.DeleteAssistantAssociationRequest
  ) extends zio.aws.wisdom.model.DeleteAssistantAssociationRequest.ReadOnly {
    override val assistantAssociationId: UuidOrArn =
      zio.aws.wisdom.model.primitives.UuidOrArn(impl.assistantAssociationId())
    override val assistantId: UuidOrArn =
      zio.aws.wisdom.model.primitives.UuidOrArn(impl.assistantId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.DeleteAssistantAssociationRequest
  ): zio.aws.wisdom.model.DeleteAssistantAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
