package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wisdom.model.primitives.UuidOrArn
import scala.jdk.CollectionConverters.*
final case class DeleteQuickResponseRequest(
    knowledgeBaseId: UuidOrArn,
    quickResponseId: UuidOrArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.DeleteQuickResponseRequest = {
    import DeleteQuickResponseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.DeleteQuickResponseRequest
      .builder()
      .knowledgeBaseId(UuidOrArn.unwrap(knowledgeBaseId): java.lang.String)
      .quickResponseId(UuidOrArn.unwrap(quickResponseId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.DeleteQuickResponseRequest.ReadOnly =
    zio.aws.wisdom.model.DeleteQuickResponseRequest.wrap(buildAwsValue())
}
object DeleteQuickResponseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.DeleteQuickResponseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.DeleteQuickResponseRequest =
      zio.aws.wisdom.model
        .DeleteQuickResponseRequest(knowledgeBaseId, quickResponseId)
    def knowledgeBaseId: UuidOrArn
    def quickResponseId: UuidOrArn
    def getKnowledgeBaseId: ZIO[Any, Nothing, UuidOrArn] =
      ZIO.succeed(knowledgeBaseId)
    def getQuickResponseId: ZIO[Any, Nothing, UuidOrArn] =
      ZIO.succeed(quickResponseId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.DeleteQuickResponseRequest
  ) extends zio.aws.wisdom.model.DeleteQuickResponseRequest.ReadOnly {
    override val knowledgeBaseId: UuidOrArn =
      zio.aws.wisdom.model.primitives.UuidOrArn(impl.knowledgeBaseId())
    override val quickResponseId: UuidOrArn =
      zio.aws.wisdom.model.primitives.UuidOrArn(impl.quickResponseId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.DeleteQuickResponseRequest
  ): zio.aws.wisdom.model.DeleteQuickResponseRequest.ReadOnly = new Wrapper(
    impl
  )
}
