package zio.aws.wisdom.model
import scala.jdk.CollectionConverters.*
sealed trait ExternalSource {
  def unwrap: software.amazon.awssdk.services.wisdom.model.ExternalSource
}
object ExternalSource {
  def wrap(
      value: software.amazon.awssdk.services.wisdom.model.ExternalSource
  ): zio.aws.wisdom.model.ExternalSource = value match {
    case software.amazon.awssdk.services.wisdom.model.ExternalSource.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.wisdom.model.ExternalSource.AMAZON_CONNECT =>
      val r = AMAZON_CONNECT
      r
  }
  case object unknownToSdkVersion extends zio.aws.wisdom.model.ExternalSource {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.ExternalSource =
      software.amazon.awssdk.services.wisdom.model.ExternalSource.UNKNOWN_TO_SDK_VERSION
  }
  case object AMAZON_CONNECT extends zio.aws.wisdom.model.ExternalSource {
    override def unwrap
        : software.amazon.awssdk.services.wisdom.model.ExternalSource =
      software.amazon.awssdk.services.wisdom.model.ExternalSource.AMAZON_CONNECT
  }
}
