package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ExternalSourceConfiguration(
    configuration: zio.aws.wisdom.model.Configuration,
    source: zio.aws.wisdom.model.ExternalSource
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.ExternalSourceConfiguration = {
    import ExternalSourceConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.ExternalSourceConfiguration
      .builder()
      .configuration(configuration.buildAwsValue())
      .source(source.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.ExternalSourceConfiguration.ReadOnly =
    zio.aws.wisdom.model.ExternalSourceConfiguration.wrap(buildAwsValue())
}
object ExternalSourceConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.ExternalSourceConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.ExternalSourceConfiguration =
      zio.aws.wisdom.model
        .ExternalSourceConfiguration(configuration.asEditable, source)
    def configuration: zio.aws.wisdom.model.Configuration.ReadOnly
    def source: zio.aws.wisdom.model.ExternalSource
    def getConfiguration
        : ZIO[Any, Nothing, zio.aws.wisdom.model.Configuration.ReadOnly] =
      ZIO.succeed(configuration)
    def getSource: ZIO[Any, Nothing, zio.aws.wisdom.model.ExternalSource] =
      ZIO.succeed(source)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.ExternalSourceConfiguration
  ) extends zio.aws.wisdom.model.ExternalSourceConfiguration.ReadOnly {
    override val configuration: zio.aws.wisdom.model.Configuration.ReadOnly =
      zio.aws.wisdom.model.Configuration.wrap(impl.configuration())
    override val source: zio.aws.wisdom.model.ExternalSource =
      zio.aws.wisdom.model.ExternalSource.wrap(impl.source())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.ExternalSourceConfiguration
  ): zio.aws.wisdom.model.ExternalSourceConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
