package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wisdom.model.primitives.UuidOrArn
import scala.jdk.CollectionConverters.*
final case class GetAssistantRequest(assistantId: UuidOrArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.GetAssistantRequest = {
    import GetAssistantRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.GetAssistantRequest
      .builder()
      .assistantId(UuidOrArn.unwrap(assistantId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.GetAssistantRequest.ReadOnly =
    zio.aws.wisdom.model.GetAssistantRequest.wrap(buildAwsValue())
}
object GetAssistantRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.GetAssistantRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.GetAssistantRequest =
      zio.aws.wisdom.model.GetAssistantRequest(assistantId)
    def assistantId: UuidOrArn
    def getAssistantId: ZIO[Any, Nothing, UuidOrArn] = ZIO.succeed(assistantId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.GetAssistantRequest
  ) extends zio.aws.wisdom.model.GetAssistantRequest.ReadOnly {
    override val assistantId: UuidOrArn =
      zio.aws.wisdom.model.primitives.UuidOrArn(impl.assistantId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.GetAssistantRequest
  ): zio.aws.wisdom.model.GetAssistantRequest.ReadOnly = new Wrapper(impl)
}
