package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wisdom.model.primitives.{UuidOrArn, Uuid}
import scala.jdk.CollectionConverters.*
final case class GetImportJobRequest(
    importJobId: Uuid,
    knowledgeBaseId: UuidOrArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.GetImportJobRequest = {
    import GetImportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.GetImportJobRequest
      .builder()
      .importJobId(Uuid.unwrap(importJobId): java.lang.String)
      .knowledgeBaseId(UuidOrArn.unwrap(knowledgeBaseId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.GetImportJobRequest.ReadOnly =
    zio.aws.wisdom.model.GetImportJobRequest.wrap(buildAwsValue())
}
object GetImportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.GetImportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.GetImportJobRequest =
      zio.aws.wisdom.model.GetImportJobRequest(importJobId, knowledgeBaseId)
    def importJobId: Uuid
    def knowledgeBaseId: UuidOrArn
    def getImportJobId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(importJobId)
    def getKnowledgeBaseId: ZIO[Any, Nothing, UuidOrArn] =
      ZIO.succeed(knowledgeBaseId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.GetImportJobRequest
  ) extends zio.aws.wisdom.model.GetImportJobRequest.ReadOnly {
    override val importJobId: Uuid =
      zio.aws.wisdom.model.primitives.Uuid(impl.importJobId())
    override val knowledgeBaseId: UuidOrArn =
      zio.aws.wisdom.model.primitives.UuidOrArn(impl.knowledgeBaseId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.GetImportJobRequest
  ): zio.aws.wisdom.model.GetImportJobRequest.ReadOnly = new Wrapper(impl)
}
