package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetImportJobResponse(
    importJob: Optional[zio.aws.wisdom.model.ImportJobData] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.GetImportJobResponse = {
    import GetImportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.GetImportJobResponse
      .builder()
      .optionallyWith(importJob.map(value => value.buildAwsValue()))(
        _.importJob
      )
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.GetImportJobResponse.ReadOnly =
    zio.aws.wisdom.model.GetImportJobResponse.wrap(buildAwsValue())
}
object GetImportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.GetImportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.GetImportJobResponse =
      zio.aws.wisdom.model
        .GetImportJobResponse(importJob.map(value => value.asEditable))
    def importJob: Optional[zio.aws.wisdom.model.ImportJobData.ReadOnly]
    def getImportJob
        : ZIO[Any, AwsError, zio.aws.wisdom.model.ImportJobData.ReadOnly] =
      AwsError.unwrapOptionField("importJob", importJob)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.GetImportJobResponse
  ) extends zio.aws.wisdom.model.GetImportJobResponse.ReadOnly {
    override val importJob
        : Optional[zio.aws.wisdom.model.ImportJobData.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importJob())
        .map(value => zio.aws.wisdom.model.ImportJobData.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.GetImportJobResponse
  ): zio.aws.wisdom.model.GetImportJobResponse.ReadOnly = new Wrapper(impl)
}
