package zio.aws.wisdom.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetQuickResponseResponse(
    quickResponse: Optional[zio.aws.wisdom.model.QuickResponseData] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wisdom.model.GetQuickResponseResponse = {
    import GetQuickResponseResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wisdom.model.GetQuickResponseResponse
      .builder()
      .optionallyWith(quickResponse.map(value => value.buildAwsValue()))(
        _.quickResponse
      )
      .build()
  }
  def asReadOnly: zio.aws.wisdom.model.GetQuickResponseResponse.ReadOnly =
    zio.aws.wisdom.model.GetQuickResponseResponse.wrap(buildAwsValue())
}
object GetQuickResponseResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wisdom.model.GetQuickResponseResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wisdom.model.GetQuickResponseResponse =
      zio.aws.wisdom.model
        .GetQuickResponseResponse(quickResponse.map(value => value.asEditable))
    def quickResponse: Optional[zio.aws.wisdom.model.QuickResponseData.ReadOnly]
    def getQuickResponse
        : ZIO[Any, AwsError, zio.aws.wisdom.model.QuickResponseData.ReadOnly] =
      AwsError.unwrapOptionField("quickResponse", quickResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wisdom.model.GetQuickResponseResponse
  ) extends zio.aws.wisdom.model.GetQuickResponseResponse.ReadOnly {
    override val quickResponse
        : Optional[zio.aws.wisdom.model.QuickResponseData.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.quickResponse())
        .map(value => zio.aws.wisdom.model.QuickResponseData.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wisdom.model.GetQuickResponseResponse
  ): zio.aws.wisdom.model.GetQuickResponseResponse.ReadOnly = new Wrapper(impl)
}
